/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.util.CoverageUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.GridRange2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.CoverageStoreInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageInfo
extends GlobalLayerSupertype {
    LayerInfo layer;
    org.geoserver.catalog.CoverageInfo coverage;
    Catalog catalog;

    public CoverageInfo(LayerInfo layer, Catalog catalog) {
        this.layer = layer;
        this.catalog = catalog;
        this.coverage = (org.geoserver.catalog.CoverageInfo)layer.getResource();
    }

    public void load(CoverageInfoDTO dto) {
        org.geoserver.catalog.CoverageStoreInfo cs = this.catalog.getCoverageStoreByName(dto.getFormatId());
        this.coverage.setStore(cs);
        this.coverage.setName(dto.getName());
        this.coverage.setTitle(dto.getLabel());
        this.coverage.setDescription(dto.getDescription());
        this.coverage.getMetadataLinks().clear();
        if (dto.getMetadataLink() != null) {
            MetadataLinkInfo ml = this.catalog.getFactory().createMetadataLink();
            new MetaDataLink(ml).load(dto.getMetadataLink());
            this.coverage.getMetadataLinks().add(ml);
        }
        this.coverage.getMetadata().put("dirName", (Serializable)((Object)dto.getDirName()));
        this.coverage.getKeywords().clear();
        this.coverage.getKeywords().addAll(dto.getKeywords());
        try {
            this.coverage.setNativeCRS(CRS.parseWKT((String)dto.getNativeCrsWKT()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String userDefinedCrsIdentifier = dto.getUserDefinedCrsIdentifier();
        this.coverage.setSRS(userDefinedCrsIdentifier);
        this.coverage.setNativeBoundingBox(new ReferencedEnvelope((Envelope)dto.getEnvelope()));
        this.coverage.setLatLonBoundingBox(new ReferencedEnvelope((Envelope)dto.getLonLatWGS84Envelope()));
        this.coverage.setGrid(dto.getGrid());
        this.coverage.getDimensions().clear();
        for (int i = 0; i < dto.getDimensions().length; ++i) {
            CoverageDimensionInfo cd = this.catalog.getFactory().createCoverageDimension();
            new CoverageDimension(cd).load(dto.getDimensions()[i]);
            this.coverage.getDimensions().add(cd);
        }
        this.coverage.getRequestSRS().clear();
        this.coverage.getRequestSRS().addAll(dto.getRequestCRSs());
        this.coverage.getResponseSRS().clear();
        this.coverage.getResponseSRS().addAll(dto.getResponseCRSs());
        this.coverage.getSupportedFormats().clear();
        this.coverage.getSupportedFormats().addAll(dto.getSupportedFormats());
        this.coverage.getInterpolationMethods().clear();
        this.coverage.getInterpolationMethods().addAll(dto.getInterpolationMethods());
        this.coverage.setDefaultInterpolationMethod(dto.getDefaultInterpolationMethod());
        this.coverage.setNativeFormat(dto.getNativeFormat());
        this.coverage.getParameters().clear();
        this.coverage.getParameters().putAll(dto.getParameters());
        this.coverage.setEnabled(cs.isEnabled());
        this.layer.setDefaultStyle(this.catalog.getStyleByName(dto.getDefaultStyle()));
        this.layer.getStyles().clear();
        for (String styleName : dto.getStyles()) {
            this.layer.getStyles().add(this.catalog.getStyleByName(styleName));
        }
        this.layer.setPath(dto.getWmsPath());
        this.layer.setName(this.coverage.getName());
        this.layer.setType(LayerInfo.Type.RASTER);
    }

    @Override
    Object toDTO() {
        CoverageInfoDTO dto = new CoverageInfoDTO();
        dto.setFormatId(this.getFormatId());
        dto.setName(this.getCoverageName());
        dto.setWmsPath(this.getWmsPath());
        dto.setLabel(this.getLabel());
        dto.setDescription(this.getDescription());
        dto.setMetadataLink(this.getMetadataLink());
        dto.setDirName(this.getDirName());
        dto.setKeywords(this.getKeywords());
        dto.setUserDefinedCrsIdentifier(this.getSrsName());
        dto.setNativeCrsWKT(this.getNativeCrsWKT());
        dto.setEnvelope(this.getEnvelope());
        dto.setLonLatWGS84Envelope(this.getWGS84LonLatEnvelope());
        dto.setGrid(this.getGrid());
        dto.setDimensions(this.getDimensions());
        dto.setDimensionNames(this.getDimensionNames());
        dto.setRequestCRSs(this.getRequestCRSs());
        dto.setResponseCRSs(this.getResponseCRSs());
        dto.setNativeFormat(this.getNativeFormat());
        dto.setSupportedFormats(this.getSupportedFormats());
        dto.setDefaultInterpolationMethod(this.getDefaultInterpolationMethod());
        dto.setInterpolationMethods(this.getInterpolationMethods());
        if (this.getDefaultStyle() != null) {
            dto.setDefaultStyle(this.getDefaultStyle().getName());
        }
        ArrayList<String> styles = new ArrayList<String>();
        for (Style style : this.getStyles()) {
            styles.add(style.getName());
        }
        dto.setStyles(styles);
        dto.setParameters(this.getParameters());
        return dto;
    }

    public CoverageStoreInfo getFormatInfo() {
        return new CoverageStoreInfo(this.coverage.getStore(), this.catalog);
    }

    public boolean isEnabled() {
        return this.coverage.isEnabled() && this.coverage.getStore().isEnabled();
    }

    public CoverageStoreInfo getFormatMetaData() {
        return new CoverageStoreInfo(this.coverage.getStore(), this.catalog);
    }

    public boolean containsMetaData(String key) {
        return this.coverage.getMetadata().get(key) != null;
    }

    public void putMetaData(String key, Object value) {
        this.coverage.getMetadata().put(key, (Serializable)value);
    }

    public Object getMetaData(String key) {
        return this.coverage.getMetadata().get(key);
    }

    public Data getData() {
        throw new UnsupportedOperationException();
    }

    public String getDefaultInterpolationMethod() {
        return this.coverage.getDefaultInterpolationMethod();
    }

    public String getDescription() {
        return this.coverage.getDescription();
    }

    public String getDirName() {
        return (String)((Object)this.coverage.getMetadata().get("dirName"));
    }

    public GeneralEnvelope getEnvelope() {
        try {
            return new GeneralEnvelope((Envelope)this.coverage.getBoundingBox());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getFormatId() {
        return this.coverage.getStore().getName();
    }

    public List getInterpolationMethods() {
        return this.coverage.getInterpolationMethods();
    }

    public List getKeywords() {
        return this.coverage.getKeywords();
    }

    public String getLabel() {
        return this.coverage.getTitle();
    }

    public Map getMeta() {
        return this.coverage.getMetadata();
    }

    public MetaDataLink getMetadataLink() {
        return this.coverage.getMetadataLinks().isEmpty() ? null : new MetaDataLink(this.coverage.getMetadataLinks().get(0));
    }

    public String getPrefix() {
        return this.coverage.getNamespace().getPrefix();
    }

    public NameSpaceInfo getNameSpace() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("This coverage is not enabled");
        }
        return new NameSpaceInfo(this.coverage.getNamespace(), this.catalog);
    }

    public String getCoverageName() {
        return this.coverage.getName();
    }

    public String getName() {
        return this.coverage.getPrefixedName();
    }

    public String getNativeFormat() {
        return this.coverage.getNativeFormat();
    }

    public List getRequestCRSs() {
        return this.coverage.getRequestSRS();
    }

    public List getResponseCRSs() {
        return this.coverage.getResponseSRS();
    }

    public String getSrsName() {
        return this.coverage.getSRS();
    }

    public List getSupportedFormats() {
        return this.coverage.getSupportedFormats();
    }

    public Style getDefaultStyle() {
        StyleInfo style = this.layer.getDefaultStyle();
        try {
            return style != null ? style.getStyle() : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ArrayList getStyles() {
        ArrayList<Style> realStyles = new ArrayList<Style>();
        for (StyleInfo si : this.layer.getStyles()) {
            try {
                realStyles.add(si.getStyle());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return realStyles;
    }

    public List<String> getStyleNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StyleInfo si : this.layer.getStyles()) {
            result.add(si.getName());
        }
        return result;
    }

    public CoordinateReferenceSystem getCrs() {
        try {
            return this.coverage.getCRS();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GridGeometry getGrid() {
        return this.coverage.getGrid();
    }

    public InternationalString[] getDimensionNames() {
        InternationalString[] dimensionNames = new InternationalString[this.coverage.getDimensions().size()];
        int i = 0;
        for (CoverageDimensionInfo dim : this.coverage.getDimensions()) {
            dimensionNames[i++] = new SimpleInternationalString(dim.getName());
        }
        return dimensionNames;
    }

    public CoverageDimension[] getDimensions() {
        CoverageDimension[] dims = new CoverageDimension[this.coverage.getDimensions().size()];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = new CoverageDimension(this.coverage.getDimensions().get(i));
        }
        return dims;
    }

    public String getNativeCrsWKT() {
        try {
            return this.coverage.getNativeCRS().toWKT();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GeneralEnvelope getWGS84LonLatEnvelope() {
        return new GeneralEnvelope((Envelope)this.coverage.getLatLonBoundingBox());
    }

    public String getWmsPath() {
        return this.layer.getPath();
    }

    public void setWmsPath(String wmsPath) {
        this.layer.setPath(wmsPath);
    }

    public GridCoverageReader getReader() {
        try {
            return this.coverage.getGridCoverageReader(null, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GridCoverageReader createReader(Hints hints) {
        try {
            return this.coverage.getGridCoverageReader(null, hints);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map getParameters() {
        return this.coverage.getParameters();
    }

    public GridCoverage getCoverage() {
        return this.getCoverage(null, null);
    }

    public GridCoverage getCoverage(GeneralEnvelope envelope, Rectangle dim) {
        GridCoverage2D gc = null;
        try {
            MathTransform transform;
            CoordinateReferenceSystem destCRS;
            CoordinateReferenceSystem sourceCRS;
            GridGeometry2D coverageGeometry = (GridGeometry2D)this.getGrid();
            Envelope2D coverageEnvelope = coverageGeometry.getEnvelope2D();
            if (envelope == null) {
                envelope = new GeneralEnvelope((Envelope)coverageEnvelope);
            }
            if (dim == null) {
                dim = coverageGeometry.getGridRange2D().getBounds();
            }
            if (!CRS.equalsIgnoreMetadata((Object)(sourceCRS = envelope.getCoordinateReferenceSystem()), (Object)(destCRS = coverageEnvelope.getCoordinateReferenceSystem())) && !(transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true)).isIdentity()) {
                envelope = CRS.transform((MathTransform)transform, (Envelope)envelope);
            }
            envelope.intersect((Envelope)coverageEnvelope);
            if (envelope.isEmpty()) {
                return null;
            }
            envelope.setCoordinateReferenceSystem(destCRS);
            GridCoverageReader reader = this.getReader();
            if (reader == null) {
                return null;
            }
            Map parameters = CoverageUtils.getParametersKVP((ParameterValueGroup)reader.getFormat().getReadParameters());
            parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D((GridEnvelope)new GridRange2D(dim), (Envelope)envelope));
            gc = (GridCoverage2D)reader.read(CoverageUtils.getParameters((ParameterValueGroup)reader.getFormat().getReadParameters(), (Map)parameters, (boolean)true));
            if (gc == null || !(gc instanceof GridCoverage2D)) {
                throw new IOException("The requested coverage could not be found.");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return gc;
    }
}

