/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import com.vividsolutions.jts.geom.Geometry;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.template.SequenceMapModel;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.MapEntry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureWrapper
extends BeansWrapper {
    static Catalog gsCatalog;

    public FeatureWrapper() {
        this.setSimpleMapWrapper(true);
    }

    private Catalog getCatalog() {
        if (gsCatalog != null) {
            return gsCatalog;
        }
        try {
            gsCatalog = (Catalog)GeoServerExtensions.bean((String)"catalog2");
            return gsCatalog;
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    protected String wrapValue(Object o) {
        return FeatureWrapper.valueToString(o);
    }

    private static String valueToString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            if (o instanceof Timestamp) {
                return DateFormat.getDateTimeInstance().format((Date)o);
            }
            if (o instanceof Time) {
                return DateFormat.getTimeInstance().format((Date)o);
            }
            return DateFormat.getInstance().format((Date)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "true" : "false";
        }
        if (o instanceof Geometry) {
            return String.valueOf(o);
        }
        return String.valueOf(o);
    }

    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object instanceof FeatureCollection) {
            SimpleHash map = new SimpleHash();
            map.put("features", (Object)new CollectionModel((Collection)DataUtilities.list((FeatureCollection)((FeatureCollection)object)), (BeansWrapper)this));
            map.put("type", (Object)this.wrap(((FeatureCollection)object).getSchema()));
            return map;
        }
        if (object instanceof SimpleFeatureType) {
            SimpleFeatureType ft = (SimpleFeatureType)object;
            LinkedHashMap attributeMap = new LinkedHashMap();
            for (int i = 0; i < ft.getAttributeCount(); ++i) {
                AttributeDescriptor type = ft.getDescriptor(i);
                HashMap<String, Object> attribute = new HashMap<String, Object>();
                attribute.put("name", type.getLocalName());
                attribute.put("type", type.getType().getBinding().getName());
                attribute.put("isGeometry", Geometry.class.isAssignableFrom(type.getType().getBinding()));
                attributeMap.put(type.getLocalName(), attribute);
            }
            SimpleHash map = new SimpleHash();
            map.put("attributes", (Object)new SequenceMapModel(attributeMap, this));
            map.put("name", (Object)ft.getTypeName());
            return map;
        }
        if (object instanceof SimpleFeature) {
            FeatureTypeInfo info;
            NamespaceInfo ns;
            SimpleFeature feature = (SimpleFeature)object;
            SimpleHash map = new SimpleHash();
            FeatureAttributesMap attributeMap = new FeatureAttributesMap(feature);
            map.putAll((Map)attributeMap);
            Catalog cat = this.getCatalog();
            if (cat != null && (ns = cat.getNamespaceByURI(feature.getFeatureType().getName().getNamespaceURI())) != null && (info = cat.getResourceByName(ns.getPrefix(), feature.getFeatureType().getName().getLocalPart(), FeatureTypeInfo.class)) != null) {
                map.put("type", (Object)info);
            }
            if (map.get("type") == null) {
                map.put("type", this.buildDummyFeatureTypeInfo(feature));
            }
            map.put("fid", (Object)feature.getID());
            map.put("typeName", (Object)feature.getFeatureType().getTypeName());
            map.put("attributes", (Object)new SequenceMapModel(attributeMap, this));
            return map;
        }
        return super.wrap(object);
    }

    private Map<String, Object> buildDummyFeatureTypeInfo(SimpleFeature f) {
        HashMap<String, Object> dummy = new HashMap<String, Object>();
        dummy.put("name", f.getFeatureType().getTypeName());
        dummy.put("title", "Layer: " + f.getFeatureType().getTypeName());
        dummy.put("abstract", "[No Abstract Provided]");
        dummy.put("description", "[No Description Provided]");
        dummy.put("keywords", new ArrayList());
        dummy.put("metadataLinks", new ArrayList());
        dummy.put("SRS", "[SRS]");
        GeometryDescriptor gd = f.getFeatureType().getGeometryDescriptor();
        if (gd != null) {
            dummy.put("nativeCRS", gd.getCoordinateReferenceSystem());
        }
        return dummy;
    }

    private static class AttributeMap
    extends AbstractMap {
        private final String attributeName;
        private final SimpleFeature feature;
        private Set entrySet;

        public AttributeMap(String attributeName, SimpleFeature feature) {
            this.attributeName = attributeName;
            this.feature = feature;
        }

        public int hashCode() {
            return this.attributeName.hashCode();
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new LinkedHashSet();
                SimpleFeatureType featureType = this.feature.getFeatureType();
                AttributeDescriptor attributeType = featureType.getDescriptor(this.attributeName);
                Object value = this.feature.getAttribute(this.attributeName);
                this.entrySet.add(new DeferredValueEntry("value", value));
                this.entrySet.add(new MapEntry((Object)"name", (Object)this.attributeName));
                this.entrySet.add(new MapEntry((Object)"type", (Object)attributeType.getType().getBinding().getName()));
                Object rawValue = value == null ? "" : value;
                boolean isGeometry = Geometry.class.isAssignableFrom(attributeType.getType().getBinding());
                this.entrySet.add(new MapEntry((Object)"isGeometry", (Object)isGeometry));
                this.entrySet.add(new MapEntry((Object)"rawValue", rawValue));
            }
            return this.entrySet;
        }

        private static class DeferredValueEntry
        extends MapEntry {
            private static final long serialVersionUID = -3919798947862996744L;

            public DeferredValueEntry(String key, Object attribute) {
                super((Object)key, attribute);
            }

            public Object getValue() {
                Object actualValue = super.getValue();
                String stringValue = FeatureWrapper.valueToString(actualValue);
                return stringValue;
            }
        }
    }

    private static class FeatureAttributesMap
    extends AbstractMap {
        private Set entrySet;
        private SimpleFeature feature;

        public FeatureAttributesMap(SimpleFeature feature) {
            this.feature = feature;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new LinkedHashSet();
                List types = this.feature.getFeatureType().getAttributeDescriptors();
                int attributeCount = types.size();
                for (int i = 0; i < attributeCount; ++i) {
                    String attName = ((AttributeDescriptor)types.get(i)).getLocalName();
                    AttributeMap attributesMap = new AttributeMap(attName, this.feature);
                    this.entrySet.add(new MapEntry((Object)attName, (Object)attributesMap));
                }
            }
            return this.entrySet;
        }
    }
}

