/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.DecoratingCoverageInfo;
import org.geoserver.security.decorators.SecuredCoverageStoreInfo;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.util.ProgressListener;

public class SecuredCoverageInfo
extends DecoratingCoverageInfo {
    SecureCatalogImpl.WrapperPolicy policy;

    public SecuredCoverageInfo(CoverageInfo delegate, SecureCatalogImpl.WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public GridCoverage getGridCoverage(ProgressListener listener, Hints hints) throws IOException {
        if (this.policy == SecureCatalogImpl.WrapperPolicy.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return super.getGridCoverage(listener, hints);
    }

    public GridCoverage getGridCoverage(ProgressListener listener, ReferencedEnvelope envelope, Hints hints) throws IOException {
        if (this.policy == SecureCatalogImpl.WrapperPolicy.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return super.getGridCoverage(listener, envelope, hints);
    }

    public GridCoverageReader getGridCoverageReader(ProgressListener listener, Hints hints) throws IOException {
        if (this.policy == SecureCatalogImpl.WrapperPolicy.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return super.getGridCoverageReader(listener, hints);
    }

    public CoverageStoreInfo getStore() {
        return new SecuredCoverageStoreInfo(super.getStore(), this.policy);
    }
}

