/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.jai;

import com.sun.media.jai.util.SunTileCache;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RecyclingTileFactory;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.jai.JAIInfo;
import org.geotools.image.jai.Registry;

public class JAIInitializer
implements GeoServerInitializer {
    public void initialize(GeoServer geoServer) throws Exception {
        this.initJAI(geoServer.getGlobal());
        geoServer.addListener(new ConfigurationListener(){

            @Override
            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                JAIInitializer.this.initJAI(global);
            }

            @Override
            public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            }

            @Override
            public void reloaded() {
            }
        });
    }

    void initJAI(GeoServerInfo global) {
        JAIInfo jai = (JAIInfo)global.getMetadata().get(JAIInfo.KEY);
        JAI jaiDef = JAI.getDefaultInstance();
        jai.setJAI(jaiDef);
        jaiDef.setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)jai.getRecycling());
        RecyclingTileFactory recyclingFactory = new RecyclingTileFactory();
        jaiDef.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)recyclingFactory);
        jaiDef.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        SunTileCache jaiCache = (SunTileCache)jaiDef.getTileCache();
        jai.setTileCache(jaiCache);
        long jaiMemory = (long)(jai.getMemoryCapacity() * (double)Runtime.getRuntime().maxMemory());
        jaiCache.setMemoryCapacity(jaiMemory);
        jaiCache.setMemoryThreshold((float)jai.getMemoryThreshold());
        jaiDef.getTileScheduler().setParallelism(jai.getTileThreads());
        jaiDef.getTileScheduler().setPrefetchParallelism(jai.getTileThreads());
        jaiDef.getTileScheduler().setPriority(jai.getTilePriority());
        jaiDef.getTileScheduler().setPrefetchPriority(jai.getTilePriority());
        ImageIO.setUseCache(jai.getImageIOCache());
        Registry.setNativeAccelerationAllowed((String)"Mosaic", (boolean)false, (JAI)jaiDef);
    }
}

