/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.cli2.Option;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.imagemosaic.BaseArgumentsManager;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MosaicIndexBuilder
extends BaseArgumentsManager
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(MosaicIndexBuilder.class);
    private static final String VERSION = "0.4";
    private static final String NAME = "MosaicIndexBuilder";
    private final Option locationOpt = this.optionBuilder.withShortName("s").withLongName("source_directory").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).create()).withDescription("path where files are located").withRequired(true).create();
    private final Option nameOpt;
    private final Option relativePathOpt;
    private final Option wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.argumentBuilder.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
    private String locationPath;
    private int numberOfLevels;
    private double[][] resolutionLevels;
    private int numFiles;
    private String wildcardString = "*.*";
    private String indexName = "index";
    private boolean mustConvertToRGB = false;
    private ColorModel actualCM = null;
    private ColorModel defaultCM = null;
    private SampleModel defaultSM = null;
    private SampleModel actualSM = null;
    private GeneralEnvelope globEnvelope = null;
    private GeneralEnvelope envelope = null;
    private byte[][] defaultPalette = null;
    private CoordinateReferenceSystem defaultCRS = null;
    private CoordinateReferenceSystem actualCRS = null;
    private boolean absolute = false;

    private void recurse(List<File> allFiles, String locationPath, Set<String> skipFiles) {
        int i;
        File dir = new File(locationPath);
        WildcardFileFilter fileFilter = new WildcardFileFilter(this.wildcardString);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        File[] dirs = dir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
        for (i = 0; i < files.length; ++i) {
            if (skipFiles.contains(files[i].getName())) continue;
            allFiles.add(files[i]);
        }
        for (i = 0; i < dirs.length; ++i) {
            this.recurse(allFiles, locationPath + '/' + dirs[i].getName(), skipFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileHandler handler = null;
        try {
            IndexedShapefileDataStore store;
            boolean append = true;
            handler = new FileHandler(new StringBuffer(this.locationPath).append("/error.txt").toString(), append);
            handler.setLevel(Level.SEVERE);
            LOGGER.addHandler(handler);
            HashSet<String> skipFiles = new HashSet<String>(Arrays.asList(this.indexName + ".shp", this.indexName + ".dbf", this.indexName + ".shx", this.indexName + ".prj", "error.txt", "error.txt.lck", this.indexName + ".properties"));
            PrecisionModel precMod = new PrecisionModel(PrecisionModel.FLOATING);
            GeometryFactory geomFactory = new GeometryFactory(precMod);
            try {
                store = new IndexedShapefileDataStore(new File(this.locationPath, this.indexName + ".shp").toURL(), true, true);
            }
            catch (MalformedURLException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                }
                this.fireException(ex);
                try {
                    if (handler != null) {
                        handler.close();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                return;
            }
            ArrayList<File> files = new ArrayList<File>();
            this.recurse(files, this.locationPath, skipFiles);
            this.numFiles = files.size();
            String validFileName = null;
            Iterator filesIt = files.iterator();
            FeatureWriter fw = null;
            boolean doneSomething = false;
            for (int i = 0; i < this.numFiles; ++i) {
                StringBuffer message;
                File fileBeingProcessed = (File)filesIt.next();
                if (!(fileBeingProcessed.exists() && fileBeingProcessed.canRead() && fileBeingProcessed.isFile())) {
                    message = new StringBuffer("Skipped file ").append(files.get(i)).append(" snce it seems invalid.");
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)i * 99.0 / (double)this.numFiles);
                    continue;
                }
                if (this.getStopThread()) {
                    message = new StringBuffer("Stopping requested at file  ").append(i).append(" of ").append(this.numFiles).append(" files");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), (double)i * 100.0 / (double)this.numFiles);
                    return;
                }
                try {
                    validFileName = fileBeingProcessed.getCanonicalPath();
                }
                catch (IOException e1) {
                    this.fireException(e1);
                    try {
                        if (handler != null) {
                            handler.close();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    return;
                }
                validFileName = validFileName.replace('\\', '/');
                validFileName = validFileName.substring(this.locationPath.length() + 1, fileBeingProcessed.getAbsolutePath().length());
                if (skipFiles.contains(validFileName)) continue;
                message = new StringBuffer("Now indexing file ").append(validFileName);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), (double)i * 100.0 / (double)this.numFiles);
                try {
                    AbstractGridFormat format;
                    ImageInputStream inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                    if (inStream == null) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.severe(fileBeingProcessed + " has been skipped since we could not get a stream for it");
                        continue;
                    }
                    inStream.mark();
                    Iterator<ImageReader> it = ImageIO.getImageReaders(inStream);
                    ImageReader r = null;
                    if (!it.hasNext()) {
                        try {
                            inStream.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            r.dispose();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        message = new StringBuffer("Skipped file ").append(files.get(i)).append(":No ImageIO readeres avalaible.");
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info(message.toString());
                        }
                        this.fireEvent(message.toString(), (double)i * 99.0 / (double)this.numFiles);
                        continue;
                    }
                    r = it.next();
                    r.setInput(inStream);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(new StringBuffer("Getting a reader").toString());
                    }
                    if ((format = (AbstractGridFormat)GridFormatFinder.findFormat(files.get(i))) instanceof UnknownFormat || format == null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        try {
                            r.dispose();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        message = new StringBuffer("Skipped file ").append(files.get(i)).append(": File format is not supported.");
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info(message.toString());
                        }
                        this.fireEvent(message.toString(), (double)i * 99.0 / (double)this.numFiles);
                        continue;
                    }
                    AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)format.getReader(files.get(i));
                    this.envelope = reader.getOriginalEnvelope();
                    this.actualCRS = reader.getCrs();
                    ImageTypeSpecifier its = r.getImageTypes(0).next();
                    boolean skipFeature = false;
                    if (this.globEnvelope == null) {
                        this.defaultCM = its.getColorModel();
                        if (this.defaultCM instanceof IndexColorModel) {
                            IndexColorModel icm = (IndexColorModel)this.defaultCM;
                            int numBands = this.defaultCM.getNumColorComponents();
                            this.defaultPalette = new byte[3][icm.getMapSize()];
                            icm.getReds(this.defaultPalette[0]);
                            icm.getGreens(this.defaultPalette[0]);
                            icm.getBlues(this.defaultPalette[0]);
                            if (numBands == 4) {
                                icm.getAlphas(this.defaultPalette[0]);
                            }
                        }
                        this.defaultSM = its.getSampleModel();
                        this.defaultCRS = this.actualCRS;
                        this.globEnvelope = new GeneralEnvelope(this.envelope);
                        r.reset();
                        try {
                            inStream.reset();
                        }
                        catch (IOException e) {
                            inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                        }
                        if (inStream == null) {
                            if (!LOGGER.isLoggable(Level.WARNING)) continue;
                            LOGGER.warning("Skipping file " + fileBeingProcessed.toString());
                            continue;
                        }
                        r.setInput(inStream);
                        this.numberOfLevels = r.getNumImages(true);
                        this.resolutionLevels = new double[2][this.numberOfLevels];
                        double[] res = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER)));
                        this.resolutionLevels[0][0] = res[0];
                        this.resolutionLevels[1][0] = res[1];
                        if (this.numberOfLevels > 1) {
                            for (int k = 0; k < this.numberOfLevels; ++k) {
                                this.resolutionLevels[0][k] = this.resolutionLevels[0][0] * (double)reader.getOriginalGridRange().getSpan(0) / (1.0 * (double)r.getWidth(k));
                                this.resolutionLevels[1][k] = this.resolutionLevels[1][0] * (double)reader.getOriginalGridRange().getSpan(1) / (1.0 * (double)r.getHeight(k));
                            }
                        }
                        SimpleFeatureTypeBuilder featureBuilder = new SimpleFeatureTypeBuilder();
                        featureBuilder.setName("mosaic_index");
                        featureBuilder.setNamespaceURI("http://www.geo-solutions.it/");
                        featureBuilder.add("location", String.class);
                        featureBuilder.add("the_geom", Polygon.class, this.actualCRS);
                        featureBuilder.setDefaultGeometry("the_geom");
                        SimpleFeatureType simpleFeatureType = featureBuilder.buildFeatureType();
                        store.createSchema(simpleFeatureType);
                        fw = store.getFeatureWriter(store.getTypeNames()[0], Transaction.AUTO_COMMIT);
                    } else {
                        this.globEnvelope.add(this.envelope);
                        this.actualCM = its.getColorModel();
                        this.actualSM = its.getSampleModel();
                        boolean bl = i > 0 ? !CRS.equalsIgnoreMetadata(this.defaultCRS, this.actualCRS) : (skipFeature = false);
                        if (skipFeature) {
                            LOGGER.warning(new StringBuffer("Skipping image ").append(files.get(i)).append(" because CRSs do not match.").toString());
                        }
                        if (skipFeature = this.checkColorModels(this.defaultCM, this.defaultPalette, this.actualCM)) {
                            LOGGER.warning(new StringBuffer("Skipping image ").append(files.get(i)).append(" because color models do not match.").toString());
                        }
                    }
                    if (!skipFeature) {
                        SimpleFeature feature = (SimpleFeature)fw.next();
                        feature.setAttribute(1, (Object)geomFactory.toGeometry(new ReferencedEnvelope(this.envelope)));
                        feature.setAttribute(0, (Object)(this.absolute ? this.locationPath + File.separatorChar + validFileName : validFileName));
                        fw.write();
                        message = new StringBuffer("Done with file ").append(files.get(i));
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(message.toString());
                        }
                        message.append('\n');
                        this.fireEvent(message.toString(), (double)(i + 1) * 99.0 / (double)this.numFiles);
                        doneSomething = true;
                    } else {
                        skipFeature = false;
                    }
                    try {
                        inStream.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        r.dispose();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    reader.dispose();
                    continue;
                }
                catch (IOException e) {
                    this.fireException(e);
                    break;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.fireException(e);
                    break;
                }
            }
            try {
                if (fw != null) {
                    fw.close();
                }
                store.dispose();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            this.createPropertiesFiles(this.globEnvelope, doneSomething);
        }
        catch (SecurityException el) {
            this.fireException(el);
            return;
        }
        catch (IOException el) {
            this.fireException(el);
            return;
        }
        finally {
            try {
                if (handler != null) {
                    handler.close();
                }
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPropertiesFiles(GeneralEnvelope globEnvelope, boolean doneSomething) {
        if (this.numFiles > 0 && doneSomething) {
            StringBuffer message = new StringBuffer("Creating final properties file ");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(message.toString());
            }
            this.fireEvent(message.toString(), 99.9);
            Properties properties = new Properties();
            properties.setProperty("AbsolutePath", Boolean.toString(this.absolute));
            properties.setProperty("NumFiles", Integer.toString(this.numFiles));
            properties.setProperty("Envelope2D", new StringBuffer(Double.toString(globEnvelope.getMinimum(0))).append(",").append(Double.toString(globEnvelope.getMinimum(1))).append(" ").append(Double.toString(globEnvelope.getMaximum(0))).append(",").append(Double.toString(globEnvelope.getMaximum(1))).toString());
            properties.setProperty("LevelsNum", Integer.toString(this.numberOfLevels));
            StringBuffer levels = new StringBuffer();
            for (int k = 0; k < this.numberOfLevels; ++k) {
                levels.append(Double.toString(this.resolutionLevels[0][k])).append(",").append(Double.toString(this.resolutionLevels[1][k]));
                if (k >= this.numberOfLevels - 1) continue;
                levels.append(" ");
            }
            properties.setProperty("Levels", levels.toString());
            properties.setProperty("Name", this.indexName);
            properties.setProperty("ExpandToRGB", Boolean.toString(this.mustConvertToRGB));
            OutputStream outStream = null;
            try {
                outStream = new BufferedOutputStream(new FileOutputStream(this.locationPath + "/" + this.indexName + ".properties"));
                properties.store(outStream, "");
            }
            catch (FileNotFoundException e) {
                this.fireEvent(e.getLocalizedMessage(), 0.0);
            }
            catch (IOException e) {
                this.fireEvent(e.getLocalizedMessage(), 0.0);
            }
            finally {
                block23: {
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block23;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
            message = new StringBuffer("Done!!!");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        } else {
            StringBuffer message = new StringBuffer("No file to process!!!");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        }
    }

    private boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
        if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
            boolean colorSpaceIsOk;
            ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
            ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
            ColorSpace defCS = defCCM.getColorSpace();
            ColorSpace actualCS = actualCCM.getColorSpace();
            boolean isBogusDef = defCS instanceof BogusColorSpace;
            boolean isBogusActual = actualCS instanceof BogusColorSpace;
            if (isBogusDef && isBogusActual) {
                BogusColorSpace def = (BogusColorSpace)defCS;
                BogusColorSpace act = (BogusColorSpace)actualCS;
                colorSpaceIsOk = def.getNumComponents() == act.getNumComponents() && def.isCS_sRGB() == act.isCS_sRGB() && def.getType() == act.getType();
            } else {
                colorSpaceIsOk = defCS.equals(actualCS);
            }
            return defCCM.getNumColorComponents() != actualCCM.getNumColorComponents() || defCCM.hasAlpha() != actualCCM.hasAlpha() || !colorSpaceIsOk || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType();
        }
        if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
            IndexColorModel defICM = (IndexColorModel)defaultCM;
            IndexColorModel actualICM = (IndexColorModel)actualCM;
            if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                return true;
            }
            if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                this.mustConvertToRGB = true;
                return false;
            }
            int numBands = actualICM.getNumColorComponents();
            byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
            actualICM.getReds(actualPalette[0]);
            actualICM.getGreens(actualPalette[0]);
            actualICM.getBlues(actualPalette[0]);
            if (numBands == 4) {
                actualICM.getAlphas(defaultPalette[0]);
            }
            block0: for (int i = 0; i < defICM.getMapSize(); ++i) {
                for (int j = 0; j < numBands; ++j) {
                    if (actualPalette[j][i] == defaultPalette[j][i]) continue;
                    this.mustConvertToRGB = true;
                    continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public MosaicIndexBuilder() {
        super(NAME, VERSION);
        this.nameOpt = this.optionBuilder.withShortName("name").withLongName("index_name").withArgument(this.argumentBuilder.withName("name").withMinimum(0).withMaximum(1).create()).withDescription("name for the index file").withRequired(false).create();
        this.relativePathOpt = this.optionBuilder.withShortName("abs").withLongName("absolute_path").withDescription("whether or not paths shuld be absolute").withRequired(false).create();
        this.addOption(this.locationOpt);
        this.addOption(this.wildcardOpt);
        this.addOption(this.nameOpt);
        this.addOption(this.relativePathOpt);
        this.finishInitialization();
    }

    @Override
    public boolean parseArgs(String[] args) {
        if (!super.parseArgs(args)) {
            return false;
        }
        this.locationPath = (String)this.getOptionValue(this.locationOpt);
        File inDir = new File(this.locationPath);
        if (!inDir.isDirectory()) {
            LOGGER.severe("Provided input dir does not exist or is not a dir!");
            return false;
        }
        try {
            this.locationPath = inDir.getCanonicalPath();
            this.locationPath = this.locationPath.replace('\\', '/');
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return false;
        }
        if (this.hasOption(this.wildcardOpt)) {
            this.wildcardString = (String)this.getOptionValue(this.wildcardOpt);
        }
        if (this.hasOption(this.nameOpt)) {
            this.indexName = (String)this.getOptionValue(this.nameOpt);
        }
        if (this.hasOption(this.relativePathOpt)) {
            this.absolute = true;
        }
        return true;
    }

    public final void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
        File inDir = new File(locationPath);
        if (!inDir.isDirectory()) {
            LOGGER.severe("Provided input dir does not exist or is not a dir!");
            throw new IllegalArgumentException("Provided input dir does not exist or is not a dir!");
        }
        try {
            this.locationPath = inDir.getCanonicalPath();
            this.locationPath = locationPath.replace('\\', '/');
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public final void setWildcardString(String wildcardString) {
        this.wildcardString = wildcardString;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public double getResolutionX() {
        return this.resolutionLevels[0][0];
    }

    public double getResolutionY() {
        return this.resolutionLevels[1][0];
    }

    public String getLocationPath() {
        return this.locationPath;
    }

    public String getWildcardString() {
        return this.wildcardString;
    }
}

