/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemorySpatialIndex {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.imagemosaic");
    private final STRtree index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemorySpatialIndex(FeatureCollection<SimpleFeatureType, SimpleFeature> features) {
        if (features == null) {
            throw new NullPointerException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature> is null, it's impossible to create an index!");
        }
        FeatureIterator<SimpleFeature> it = null;
        try {
            it = features.features();
            if (!it.hasNext()) {
                throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
            }
            this.index = new STRtree();
            while (it.hasNext()) {
                SimpleFeature feature = it.next();
                Geometry g = (Geometry)feature.getDefaultGeometry();
                this.index.insert(g.getEnvelopeInternal(), (Object)feature);
            }
            this.index.build();
        }
        finally {
            if (it != null) {
                features.close(it);
            }
        }
    }

    public List<SimpleFeature> findFeatures(Envelope envelope) {
        if (envelope == null) {
            throw new NullPointerException("The provided envelope cannot be null");
        }
        return this.index.query(envelope);
    }

    void findFeatures(Envelope envelope, ItemVisitor visitor) {
        if (envelope == null) {
            throw new NullPointerException("The provided envelope cannot be null");
        }
        if (visitor == null) {
            throw new NullPointerException("The provided visitor cannot be null");
        }
        this.index.query(envelope, visitor);
    }
}

