/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.AffineDescriptor;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.ReadType;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class Granule {
    private static final Logger LOGGER = Logging.getLogger(Granule.class);
    ReferencedEnvelope granuleBBOX;
    File granuleFile;
    final Map<Integer, Level> granuleLevels = Collections.synchronizedMap(new HashMap());
    AffineTransform baseGridToWorld;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Granule(BoundingBox granuleBBOX, File granuleFile) {
        this.granuleBBOX = ReferencedEnvelope.reference(granuleBBOX);
        this.granuleFile = granuleFile;
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            inStream = ReadType.getInputStream(granuleFile);
            if (inStream == null) {
                throw new IllegalArgumentException();
            }
            reader = ReadType.getReader(inStream);
            if (reader == null) {
                throw new IllegalArgumentException();
            }
            Rectangle originalDimension = new Rectangle();
            ReadType.getDimension(0, originalDimension, inStream, reader);
            GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(originalDimension), (Envelope)granuleBBOX);
            geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
            this.baseGridToWorld = geMapper.createAffineTransform();
            this.granuleLevels.put(0, new Level(1.0, 1.0, originalDimension.width, originalDimension.height, this.baseGridToWorld));
            return;
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage loadGranuleRaster(ImageReadParam readParameters, int imageChoice, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, RasterLayerRequest request) throws IOException {
        RenderedImage renderedImage;
        if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
            LOGGER.fine("Loading raster data for granule");
        }
        ReferencedEnvelope bbox = new ReferencedEnvelope(this.granuleBBOX);
        ReferencedEnvelope intersection = new ReferencedEnvelope(bbox.intersection(cropBBox), cropBBox.getCoordinateReferenceSystem());
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            inStream = ReadType.getInputStream(this.granuleFile);
            if (inStream == null) {
                RenderedImage renderedImage2 = null;
                return renderedImage2;
            }
            reader = ReadType.getReader(inStream);
            if (reader == null) {
                if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                    LOGGER.warning("Unable to get reader for file " + this.granuleFile.getAbsolutePath());
                }
                RenderedImage renderedImage3 = null;
                return renderedImage3;
            }
            Level selectedlevel = this.getLevel(imageChoice);
            MathTransform2D cropWorldToGrid = (MathTransform2D)ProjectiveTransform.create(selectedlevel.gridToWorldTransform).inverse();
            Rectangle sourceArea = CRS.transform((MathTransform)cropWorldToGrid, (Envelope)new GeneralEnvelope(intersection)).toRectangle2D().getBounds();
            XRectangle2D.intersect(sourceArea, selectedlevel.bounds, sourceArea);
            if (sourceArea.isEmpty()) {
                if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                    LOGGER.warning("Got empty area for file " + this.granuleFile.getAbsolutePath());
                }
                RenderedImage renderedImage4 = null;
                return renderedImage4;
            }
            if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                LOGGER.fine(new StringBuffer("Loading level ").append(imageChoice).append(" with source region ").append(sourceArea).toString());
            }
            readParameters.setSourceRegion(sourceArea);
            RenderedImage raster = request.getReadType().read(readParameters, imageChoice, this.granuleFile, selectedlevel.bounds);
            if (raster == null) {
                RenderedImage renderedImage5 = null;
                return renderedImage5;
            }
            sourceArea.setRect(readParameters.getSourceRegion());
            double decimationScaleX = 1.0 * (double)sourceArea.width / (double)raster.getWidth();
            double decimationScaleY = 1.0 * (double)sourceArea.height / (double)raster.getHeight();
            AffineTransform decimationScaleTranform = XAffineTransform.getScaleInstance(decimationScaleX, decimationScaleY);
            AffineTransform afterDecimationTranslateTranform = XAffineTransform.getTranslateInstance(sourceArea.x, sourceArea.y);
            AffineTransform backToBaseLevelScaleTransform = selectedlevel.baseToLevelTransform;
            AffineTransform tempRaster2Model = new AffineTransform(this.baseGridToWorld);
            tempRaster2Model.concatenate(ImageMosaicUtils.centerToCornerTransformation);
            if (!XAffineTransform.isIdentity(backToBaseLevelScaleTransform, 1.0E-5)) {
                tempRaster2Model.concatenate(backToBaseLevelScaleTransform);
            }
            if (!XAffineTransform.isIdentity(afterDecimationTranslateTranform, 1.0E-5)) {
                tempRaster2Model.concatenate(afterDecimationTranslateTranform);
            }
            if (!XAffineTransform.isIdentity(decimationScaleTranform, 1.0E-5)) {
                tempRaster2Model.concatenate(decimationScaleTranform);
            }
            AffineTransform translationTransform = new AffineTransform((AffineTransform)mosaicWorldToGrid);
            translationTransform.concatenate(tempRaster2Model);
            RenderingHints localHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            if (XAffineTransform.isIdentity(translationTransform, 1.0E-5)) {
                RenderedImage renderedImage6 = raster;
                return renderedImage6;
            }
            Dimension tileDimensions = request.getTileDimensions();
            if (tileDimensions != null && request.getReadType().equals((Object)ReadType.DIRECT_READ)) {
                ImageLayout layout = new ImageLayout();
                layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
                localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
            RenderedOp renderedOp = AffineDescriptor.create((RenderedImage)raster, (AffineTransform)translationTransform, (Interpolation)new InterpolationNearest(), (double[])request.getBackgroundValues(), (RenderingHints)localHints);
            return renderedOp;
        }
        catch (IllegalStateException e) {
            if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                LOGGER.log(java.util.logging.Level.WARNING, e.getLocalizedMessage(), e);
            }
            renderedImage = null;
            return renderedImage;
        }
        catch (NoninvertibleTransformException e) {
            if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                LOGGER.log(java.util.logging.Level.WARNING, e.getLocalizedMessage(), e);
            }
            renderedImage = null;
            return renderedImage;
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                LOGGER.log(java.util.logging.Level.WARNING, e.getLocalizedMessage(), e);
            }
            renderedImage = null;
            return renderedImage;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Level getLevel(int index) {
        Map<Integer, Level> map = this.granuleLevels;
        synchronized (map) {
            if (this.granuleLevels.containsKey(index)) {
                return this.granuleLevels.get(index);
            }
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = ReadType.getInputStream(this.granuleFile);
                if (inStream == null) {
                    throw new IllegalArgumentException();
                }
                reader = ReadType.getReader(inStream);
                if (reader == null) {
                    throw new IllegalArgumentException();
                }
                Rectangle levelDimension = new Rectangle();
                ReadType.getDimension(index, levelDimension, inStream, reader);
                Level baseLevel = this.granuleLevels.get(0);
                double scaleX = (double)baseLevel.width / (1.0 * (double)levelDimension.width);
                double scaleY = (double)baseLevel.height / (1.0 * (double)levelDimension.height);
                Level newLevel = new Level(scaleX, scaleY, levelDimension.width, levelDimension.height, this.baseGridToWorld);
                this.granuleLevels.put(index, newLevel);
                Level level = newLevel;
                return level;
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
            }
        }
    }

    static class Level {
        final double scaleX;
        final double scaleY;
        final int width;
        final int height;
        final AffineTransform baseToLevelTransform;
        final AffineTransform gridToWorldTransform;
        final Rectangle bounds;

        public AffineTransform getBaseToLevelTransform() {
            return this.baseToLevelTransform;
        }

        public double getScaleX() {
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Level(double scaleX, double scaleY, int width, int height, AffineTransform baseGridToWorld) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.baseToLevelTransform = XAffineTransform.getScaleInstance(scaleX, scaleY, 0.0, 0.0);
            this.gridToWorldTransform = (AffineTransform)this.baseToLevelTransform.clone();
            this.gridToWorldTransform.preConcatenate(ImageMosaicUtils.centerToCornerTransformation);
            this.gridToWorldTransform.preConcatenate(baseGridToWorld);
            this.width = width;
            this.height = height;
            this.bounds = new Rectangle(0, 0, width, height);
        }

        public Rectangle getBounds() {
            return (Rectangle)this.bounds.clone();
        }

        public AffineTransform getGridToWorldTransform() {
            return this.gridToWorldTransform;
        }
    }
}

