/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Message;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response
extends Message {
    private Set<Method> allowedMethods = null;
    private ChallengeRequest challengeRequest = null;
    private Series<CookieSetting> cookieSettings = null;
    private Set<Dimension> dimensions = null;
    private Reference redirectRef = null;
    private Request request;
    private ServerInfo serverInfo;
    private Status status;

    public Response(Request request) {
        this.request = request;
        this.serverInfo = null;
        this.status = Status.SUCCESS_OK;
    }

    public Set<Method> getAllowedMethods() {
        if (this.allowedMethods == null) {
            this.allowedMethods = new HashSet<Method>();
        }
        return this.allowedMethods;
    }

    public ChallengeRequest getChallengeRequest() {
        return this.challengeRequest;
    }

    public Series<CookieSetting> getCookieSettings() {
        if (this.cookieSettings == null) {
            this.cookieSettings = new CookieSettingSeries();
        }
        return this.cookieSettings;
    }

    public Set<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = EnumSet.noneOf(Dimension.class);
        }
        return this.dimensions;
    }

    public Reference getRedirectRef() {
        return this.redirectRef;
    }

    public Request getRequest() {
        return this.request;
    }

    public ServerInfo getServerInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = new ServerInfo();
        }
        return this.serverInfo;
    }

    public Status getStatus() {
        return this.status;
    }

    public void redirectPermanent(String targetUri) {
        this.redirectPermanent(new Reference(targetUri));
    }

    public void redirectPermanent(Reference targetRef) {
        this.setRedirectRef(targetRef);
        this.setStatus(Status.REDIRECTION_PERMANENT);
    }

    public void redirectSeeOther(String targetUri) {
        this.redirectSeeOther(new Reference(targetUri));
    }

    public void redirectSeeOther(Reference targetRef) {
        this.setRedirectRef(targetRef);
        this.setStatus(Status.REDIRECTION_SEE_OTHER);
    }

    public void redirectTemporary(String targetUri) {
        this.redirectTemporary(new Reference(targetUri));
    }

    public void redirectTemporary(Reference targetRef) {
        this.setRedirectRef(targetRef);
        this.setStatus(Status.REDIRECTION_TEMPORARY);
    }

    public void setChallengeRequest(ChallengeRequest request) {
        this.challengeRequest = request;
    }

    public void setRedirectRef(Reference redirectRef) {
        this.redirectRef = redirectRef;
    }

    public void setRedirectRef(String redirectUri) {
        Reference baseRef = this.getRequest().getResourceRef() != null ? this.getRequest().getResourceRef().getBaseRef() : null;
        this.setRedirectRef(new Reference(baseRef, redirectUri).getTargetRef());
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStatus(Status status, String message) {
        this.setStatus(new Status(status, message));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CookieSettingSeries
    extends Series<CookieSetting> {
        public CookieSettingSeries() {
        }

        public CookieSettingSeries(List<CookieSetting> delegate) {
            super(delegate);
        }

        @Override
        public CookieSetting createEntry(String name, String value) {
            return new CookieSetting(name, value);
        }

        @Override
        public Series<CookieSetting> createSeries(List<CookieSetting> delegate) {
            if (delegate != null) {
                return new CookieSettingSeries(delegate);
            }
            return new CookieSettingSeries();
        }
    }
}

