/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.rest.AbstractResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.geoserver.rest.format.ReflectiveJSONFormat;
import org.geoserver.rest.format.ReflectiveXMLFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveResource
extends AbstractResource {
    public ReflectiveResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    public ReflectiveResource() {
    }

    public final void handleGet() {
        DataFormat format = this.getFormatGet();
        try {
            this.getResponse().setEntity(format.toRepresentation(this.handleObjectGet()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected abstract Object handleObjectGet() throws Exception;

    public final void handlePost() {
        DataFormat format = this.getFormatPostOrPut();
        Object object = format.toObject(this.getRequest().getEntity());
        String location = null;
        try {
            location = this.handleObjectPost(object);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (location != null) {
            String uri = this.getRequest().getResourceRef().getIdentifier();
            int question = uri.indexOf(63);
            if (question != -1) {
                uri = uri.substring(0, question);
            }
            uri = ResponseUtils.appendPath((String)uri, (String)location);
            this.getResponse().redirectSeeOther(uri);
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
        }
    }

    protected String handleObjectPost(Object object) throws Exception {
        return null;
    }

    public final void handlePut() {
        DataFormat format = this.getFormatPostOrPut();
        Object object = format.toObject(this.getRequest().getEntity());
        try {
            this.handleObjectPut(object);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleObjectPut(Object object) throws Exception {
    }

    public final void handleDelete() {
        try {
            this.handleObjectDelete();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleObjectDelete() throws Exception {
    }

    @Override
    protected List<DataFormat> createSupportedFormats(Request request, Response response) {
        ArrayList<DataFormat> formats = new ArrayList<DataFormat>();
        formats.add(this.createHTMLFormat(request, response));
        formats.add(this.createXMLFormat(request, response));
        formats.add(this.createJSONFormat(request, response));
        return formats;
    }

    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new ReflectiveHTMLFormat(request, response, this);
    }

    protected ReflectiveXMLFormat createXMLFormat(Request request, Response response) {
        ReflectiveXMLFormat format = new ReflectiveXMLFormat();
        this.configureXStream(format.getXStream());
        return format;
    }

    protected ReflectiveJSONFormat createJSONFormat(Request request, Response response) {
        ReflectiveJSONFormat format = new ReflectiveJSONFormat();
        this.configureXStream(format.getXStream());
        return format;
    }

    protected void configureXStream(XStream xstream) {
    }

    protected String getAttribute(String attribute) {
        Object o = this.getRequest().getAttributes().get(attribute);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    void handleException(Exception e) throws RestletException {
        if (e instanceof RestletException) {
            throw (RestletException)e;
        }
        throw new RestletException("", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
    }
}

