/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input.spi;

import it.geosolutions.imageio.stream.input.spi.FileImageInputStreamExtImplSpi;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class URLImageInputStreamSpi
extends ImageInputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.input");
    private static final FileImageInputStreamExtImplSpi fileStreamSPI = new FileImageInputStreamExtImplSpi();
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class inputClass = URL.class;

    public static File urlToFile(URL url) {
        String path3;
        String string = url.toExternalForm();
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        String simplePrefix = "file:/";
        String standardPrefix = simplePrefix + "/";
        if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath().replace("%20", " ");
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }

    public URLImageInputStreamSpi() {
        super(vendorName, version, inputClass);
    }

    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) {
        if (!(input instanceof URL)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("The provided input is not a valid URL.");
            }
            return null;
        }
        try {
            URL sourceURL = (URL)input;
            File tempFile = URLImageInputStreamSpi.urlToFile(sourceURL);
            if (tempFile.exists() && tempFile.isFile() && tempFile.canRead()) {
                return fileStreamSPI.createInputStreamInstance(tempFile, useCache, cacheDir);
            }
            if (useCache) {
                return new MemoryCacheImageInputStream(sourceURL.openStream());
            }
            return new FileCacheImageInputStream(sourceURL.openStream(), cacheDir);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public String getDescription(Locale locale) {
        return "Service provider that helps connecting to the onject pointed by a URL";
    }
}

