/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response.v1_1_0;

import java.io.IOException;
import java.io.OutputStream;
import net.opengis.wfs.ActionType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.response.v1_1_0.WFS11Response;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.vfny.geoserver.global.Data;

public class TransactionResponse
extends WFS11Response {
    WFS wfs;
    Data catalog;
    WFSConfiguration configuration;

    public TransactionResponse(WFS wfs, Data catalog, WFSConfiguration configuration) {
        super(TransactionResponseType.class);
        this.wfs = wfs;
        this.catalog = catalog;
        this.configuration = configuration;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        TransactionResponseType response = (TransactionResponseType)value;
        if (!response.getTransactionResults().getAction().isEmpty()) {
            ActionType action = (ActionType)response.getTransactionResults().getAction().iterator().next();
            throw new WFSException(action.getMessage(), action.getCode(), action.getLocator());
        }
        Encoder encoder = new Encoder((Configuration)this.configuration, this.configuration.schema());
        encoder.setEncoding(this.wfs.getCharSet());
        TransactionType req = (TransactionType)operation.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)req.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.1.0/wfs.xsd"));
        encoder.encode((Object)response, org.geoserver.wfs.xml.v1_1_0.WFS.TRANSACTIONRESPONSE, output);
    }
}

