/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.io.Writer;
import net.sf.json.JSONException;
import net.sf.json.util.JSONBuilder;

public class GeoJSONBuilder
extends JSONBuilder {
    protected static final int POINT = 1;
    protected static final int LINESTRING = 2;
    protected static final int POLYGON = 3;
    protected static final int MULTIPOINT = 4;
    protected static final int MULTILINESTRING = 5;
    protected static final int MULTIPOLYGON = 6;
    protected static final int MULTIGEOMETRY = 7;

    public GeoJSONBuilder(Writer w) {
        super(w);
    }

    public JSONBuilder writeGeom(Geometry geometry) throws JSONException {
        this.object();
        this.key("type");
        this.value(GeoJSONBuilder.getGeometryName(geometry));
        int geometryType = GeoJSONBuilder.getGeometryType(geometry);
        if (geometryType != 7) {
            this.key("coordinates");
            switch (geometryType) {
                case 1: {
                    Point point = (Point)geometry;
                    this.writeCoordinate(point.getX(), point.getY());
                    break;
                }
                case 2: {
                    this.writeCoordinates(((LineString)geometry).getCoordinateSequence());
                    break;
                }
                case 4: {
                    this.writeCoordinates(geometry.getCoordinates());
                    break;
                }
                case 3: {
                    this.writePolygon((Polygon)geometry);
                    break;
                }
                case 5: {
                    this.array();
                    int n = geometry.getNumGeometries();
                    for (int i = 0; i < n; ++i) {
                        this.writeCoordinates(((LineString)geometry.getGeometryN(i)).getCoordinateSequence());
                    }
                    this.endArray();
                    break;
                }
                case 6: {
                    this.array();
                    int n = geometry.getNumGeometries();
                    for (int i = 0; i < n; ++i) {
                        this.writePolygon((Polygon)geometry.getGeometryN(i));
                    }
                    this.endArray();
                }
            }
        } else {
            this.writeGeomCollection((GeometryCollection)geometry);
        }
        return this.endObject();
    }

    private JSONBuilder writeGeomCollection(GeometryCollection collection) {
        this.array();
        this.key("geometries");
        int n = collection.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            this.writeGeom(collection.getGeometryN(i));
        }
        return this.endArray();
    }

    private JSONBuilder writeCoordinates(Coordinate[] coords) throws JSONException {
        return this.writeCoordinates((CoordinateSequence)new CoordinateArraySequence(coords));
    }

    private JSONBuilder writeCoordinates(CoordinateSequence coords) throws JSONException {
        this.array();
        int coordCount = coords.size();
        for (int i = 0; i < coordCount; ++i) {
            this.writeCoordinate(coords.getX(i), coords.getY(i));
        }
        return this.endArray();
    }

    private JSONBuilder writeCoordinate(double x, double y) {
        this.array();
        this.value(x);
        this.value(y);
        return this.endArray();
    }

    protected JSONBuilder writeBoundingBox(Envelope env) {
        this.key("bbox");
        this.array();
        this.value(env.getMinX());
        this.value(env.getMinY());
        this.value(env.getMaxX());
        this.value(env.getMaxY());
        return this.endArray();
    }

    private void writePolygon(Polygon geometry) throws JSONException {
        this.array();
        this.writeCoordinates(geometry.getExteriorRing().getCoordinateSequence());
        int ii = geometry.getNumInteriorRing();
        for (int i = 0; i < ii; ++i) {
            this.writeCoordinates(geometry.getInteriorRingN(i).getCoordinateSequence());
        }
        this.endArray();
    }

    public static String getGeometryName(Geometry geometry) {
        Class<?> geomClass = geometry.getClass();
        String returnValue = null;
        returnValue = geomClass.equals(Point.class) ? "Point" : (geomClass.equals(LineString.class) ? "LineString" : (geomClass.equals(Polygon.class) ? "Polygon" : (geomClass.equals(MultiPoint.class) ? "MultiPoint" : (geomClass.equals(MultiLineString.class) ? "MultiLineString" : (geomClass.equals(MultiPolygon.class) ? "MultiPolygon" : (geomClass.equals(GeometryCollection.class) ? "GeometryCollection" : null))))));
        return returnValue;
    }

    public static int getGeometryType(Geometry geometry) {
        Class<?> geomClass = geometry.getClass();
        int returnValue = -1;
        returnValue = geomClass.equals(Point.class) ? 1 : (geomClass.equals(LineString.class) ? 2 : (geomClass.equals(Polygon.class) ? 3 : (geomClass.equals(MultiPoint.class) ? 4 : (geomClass.equals(MultiLineString.class) ? 5 : (geomClass.equals(MultiPolygon.class) ? 6 : (geomClass.equals(GeometryCollection.class) ? 7 : -1))))));
        return returnValue;
    }
}

