/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import javax.xml.namespace.QName;
import org.geoserver.ows.FlatKvpParser;
import org.geoserver.wfs.WFSException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.NameSpaceInfo;

public class QNameKvpParser
extends FlatKvpParser {
    Data catalog;

    public QNameKvpParser(String key, Data catalog) {
        super(key, QName.class);
        this.catalog = catalog;
    }

    protected Object parseToken(String token) throws Exception {
        int i = token.indexOf(58);
        if (i != -1) {
            String prefix = token.substring(0, i);
            String local = token.substring(i + 1);
            String uri = null;
            if (prefix != null && !"".equals(prefix)) {
                NameSpaceInfo namespace = this.catalog.getNameSpace(prefix);
                if (namespace == null) {
                    throw new WFSException("Unknown namespace [" + prefix + "]");
                }
                uri = namespace.getURI();
            }
            return new QName(uri, local, prefix);
        }
        String uri = this.catalog.getDefaultNameSpace().getURI();
        String prefix = this.catalog.getDefaultPrefix();
        String local = token;
        return new QName(uri, local, prefix);
    }
}

