/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WebFeatureService;
import org.geoserver.wfs.kvp.QNameKvpParser;
import org.geoserver.wfs.kvp.WFSKvpRequestReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.util.Version;
import org.geotools.xml.EMFUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class GetFeatureKvpRequestReader
extends WFSKvpRequestReader {
    Data catalog;
    FilterFactory filterFactory;
    WebFeatureService wfs;

    public GetFeatureKvpRequestReader(Class requestBean, Data catalog, FilterFactory filterFactory, WebFeatureService wfs) {
        super(requestBean);
        this.catalog = catalog;
        this.filterFactory = filterFactory;
        this.wfs = wfs;
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        List<Object> filters;
        request = super.read(request, kvp, rawKvp);
        this.ensureMutuallyExclusive(kvp, new String[]{"featureId", "filter", "bbox", "cql_filter"});
        EObject eObject = (EObject)request;
        if (!EMFUtils.isSet((EObject)eObject, (String)"outputFormat")) {
            Version version = RequestUtils.version((String)((String)EMFUtils.get((EObject)eObject, (String)"version")));
            if ((version = RequestUtils.matchHighestVersion((Version)version, this.wfs.getVersions())) != null && version.toString().startsWith("1.0")) {
                EMFUtils.set((EObject)eObject, (String)"outputFormat", (Object)"GML2");
            } else {
                EMFUtils.set((EObject)eObject, (String)"outputFormat", (Object)"text/xml; subtype=gml/3.1.1");
            }
        }
        if (kvp.containsKey("typeName")) {
            List typeName = (List)kvp.get("typeName");
            ArrayList list = new ArrayList();
            for (QName qName : typeName) {
                if (this.catalog.getFeatureTypeInfo(qName) == null) {
                    String name = qName.getPrefix() + ":" + qName.getLocalPart();
                    throw new WFSException("Feature type " + name + " unknown", "InvalidParameterValue", "typeName");
                }
                ArrayList<QName> l = new ArrayList<QName>();
                l.add(qName);
                list.add(l);
            }
            kvp.put("typeName", list);
            this.querySet(eObject, "typeName", list);
        } else if (kvp.containsKey("featureId")) {
            List featureId = (List)kvp.get("featureId");
            ArrayList<List> typeNames = new ArrayList<List>();
            QNameKvpParser parser = new QNameKvpParser("typeName", this.catalog);
            for (int i = 0; i < featureId.size(); ++i) {
                String fid = (String)featureId.get(i);
                int pos = fid.indexOf(".");
                if (pos == -1) continue;
                String typeName = fid.substring(0, fid.lastIndexOf("."));
                List parsed = (List)parser.parse(typeName);
                typeNames.add(parsed);
            }
            this.querySet(eObject, "typeName", typeNames);
        } else {
            throw new WFSException("The query should specify either typeName or a featureId filter", "MissingParameterValue");
        }
        if (kvp.containsKey("filter")) {
            this.querySet(eObject, "filter", (List)kvp.get("filter"));
        } else if (kvp.containsKey("cql_filter")) {
            this.querySet(eObject, "filter", (List)kvp.get("cql_filter"));
        } else if (kvp.containsKey("featureId")) {
            List featureIdList = (List)kvp.get("featureId");
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            for (String fid : featureIdList) {
                FeatureId featureId = this.filterFactory.featureId(fid);
                ids.add(featureId);
            }
            filters = Collections.singletonList(this.filterFactory.id(ids));
            this.querySet(eObject, "filter", filters);
        } else if (kvp.containsKey("bbox")) {
            Envelope bbox = (Envelope)kvp.get("bbox");
            List queries = (List)EMFUtils.get((EObject)eObject, (String)"query");
            filters = new ArrayList();
            for (QueryType query : queries) {
                List typeName = query.getTypeName();
                BBOX filter = null;
                if (typeName.size() > 1) {
                    ArrayList<BBOX> and = new ArrayList<BBOX>(typeName.size());
                    Iterator t = typeName.iterator();
                    while (t.hasNext()) {
                        and.add(this.bboxFilter((QName)t.next(), bbox));
                    }
                    filter = this.filterFactory.and(and);
                } else {
                    filter = this.bboxFilter((QName)typeName.get(0), bbox);
                }
                filters.add(filter);
            }
            this.querySet(eObject, "filter", filters);
        }
        if (kvp.containsKey("propertyName")) {
            this.querySet(eObject, "propertyName", (List)kvp.get("propertyName"));
        }
        if (kvp.containsKey("sortBy")) {
            this.querySet(eObject, "sortBy", (List)kvp.get("sortBy"));
        }
        if (kvp.containsKey("srsName")) {
            this.querySet(eObject, "srsName", (List)kvp.get("srsName"));
        }
        if (kvp.containsKey("featureVersion")) {
            this.querySet(eObject, "featureVersion", Collections.singletonList((String)kvp.get("featureVersion")));
        }
        if (kvp.containsKey("format_options")) {
            GetFeatureType gft = (GetFeatureType)eObject;
            gft.getFormatOptions().putAll((Map)kvp.get("format_options"));
        }
        return request;
    }

    private void ensureMutuallyExclusive(Map kvp, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            if (!kvp.containsKey(keys[i])) continue;
            for (int j = i + 1; j < keys.length; ++j) {
                if (!kvp.containsKey(keys[j])) continue;
                String msg = keys[i] + " and " + keys[j] + " both specified but are mutually exclusive";
                throw new WFSException(msg);
            }
        }
    }

    BBOX bboxFilter(QName typeName, Envelope bbox) throws Exception {
        CoordinateReferenceSystem crs;
        FeatureTypeInfo featureTypeInfo = this.catalog.getFeatureTypeInfo(typeName);
        SimpleFeatureType featureType = featureTypeInfo.getFeatureType();
        String name = "";
        String epsgCode = null;
        if (bbox instanceof ReferencedEnvelope && (crs = ((ReferencedEnvelope)bbox).getCoordinateReferenceSystem()) != null) {
            epsgCode = GML2EncodingUtils.crs((CoordinateReferenceSystem)crs);
        }
        return this.filterFactory.bbox(name, bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), epsgCode);
    }

    protected void querySet(EObject request, String property, List values) throws WFSException {
        if (values == null) {
            return;
        }
        List query = (List)EMFUtils.get((EObject)request, (String)"query");
        int m = values.size();
        int n = query.size();
        if (m == 1 && n > 1) {
            EMFUtils.set((List)query, (String)property, values.get(0));
            return;
        }
        if (m > n) {
            if (n == 0) {
                for (int i = 0; i < m; ++i) {
                    query.add(this.getWfsFactory().createQueryType());
                }
            } else {
                if (n == 1) {
                    EObject q = (EObject)query.get(0);
                    for (int i = 1; i < m; ++i) {
                        query.add(EMFUtils.clone((EObject)q, (EFactory)this.getWfsFactory()));
                    }
                    return;
                }
                String msg = "Specified " + m + " " + property + " for " + n + " queries.";
                throw new WFSException(msg);
            }
        }
        EMFUtils.set((List)query, (String)property, (List)values);
    }
}

