/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.URL;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AbstractStyleFactory;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapEntryImpl;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.Displacement;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.Extent;
import org.geotools.styling.ExtentImpl;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeConstraintImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.Halo;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.ImageOutlineImpl;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LayerFeatureConstraints;
import org.geotools.styling.LayerFeatureConstraintsImpl;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedLayerImpl;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.NamedStyleImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RasterSymbolizerImpl;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.RemoteOWSImpl;
import org.geotools.styling.Rule;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory2;
import org.geotools.styling.StyleImpl;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.StyledLayerDescriptorImpl;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.TextSymbolizerImpl;
import org.geotools.styling.UserLayer;
import org.geotools.styling.UserLayerImpl;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class StyleFactoryImpl
extends AbstractStyleFactory
implements StyleFactory2 {
    private FilterFactory filterFactory;

    public StyleFactoryImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    protected StyleFactoryImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public Style createStyle() {
        return new StyleImpl();
    }

    public NamedStyle createNamedStyle() {
        return new NamedStyleImpl();
    }

    public PointSymbolizer createPointSymbolizer() {
        return new PointSymbolizerImpl();
    }

    public PointSymbolizer createPointSymbolizer(Graphic graphic, String geometryPropertyName) {
        PointSymbolizerImpl pSymb = new PointSymbolizerImpl();
        pSymb.setGeometryPropertyName(geometryPropertyName);
        pSymb.setGraphic(graphic);
        return pSymb;
    }

    public PolygonSymbolizer createPolygonSymbolizer() {
        return new PolygonSymbolizerImpl();
    }

    public PolygonSymbolizer createPolygonSymbolizer(Stroke stroke, Fill fill, String geometryPropertyName) {
        PolygonSymbolizerImpl pSymb = new PolygonSymbolizerImpl();
        pSymb.setGeometryPropertyName(geometryPropertyName);
        pSymb.setStroke(stroke);
        pSymb.setFill(fill);
        return pSymb;
    }

    public LineSymbolizer createLineSymbolizer() {
        return new LineSymbolizerImpl();
    }

    public LineSymbolizer createLineSymbolizer(Stroke stroke, String geometryPropertyName) {
        LineSymbolizerImpl lSymb = new LineSymbolizerImpl();
        lSymb.setGeometryPropertyName(geometryPropertyName);
        lSymb.setStroke(stroke);
        return lSymb;
    }

    public TextSymbolizer createTextSymbolizer() {
        return new TextSymbolizerImpl();
    }

    public TextSymbolizer createTextSymbolizer(Fill fill, Font[] fonts, Halo halo, Expression label, LabelPlacement labelPlacement, String geometryPropertyName) {
        TextSymbolizerImpl tSymb = new TextSymbolizerImpl();
        tSymb.setFill(fill);
        tSymb.setFonts(fonts);
        tSymb.setGeometryPropertyName(geometryPropertyName);
        tSymb.setHalo(halo);
        tSymb.setLabel(label);
        tSymb.setPlacement(labelPlacement);
        return tSymb;
    }

    public TextSymbolizer2 createTextSymbolizer(Fill fill, Font[] fonts, Halo halo, Expression label, LabelPlacement labelPlacement, String geometryPropertyName, Graphic graphic) {
        TextSymbolizerImpl tSymb = new TextSymbolizerImpl();
        tSymb.setFill(fill);
        tSymb.setFonts(fonts);
        tSymb.setGeometryPropertyName(geometryPropertyName);
        tSymb.setHalo(halo);
        tSymb.setLabel(label);
        tSymb.setPlacement(labelPlacement);
        tSymb.setGraphic(graphic);
        return tSymb;
    }

    public Extent createExtent(String name, String value) {
        ExtentImpl extent = new ExtentImpl();
        extent.setName(name);
        extent.setValue(value);
        return extent;
    }

    public FeatureTypeConstraint createFeatureTypeConstraint(String featureTypeName, Filter filter, Extent[] extents) {
        FeatureTypeConstraintImpl constraint = new FeatureTypeConstraintImpl();
        constraint.setFeatureTypeName(featureTypeName);
        constraint.setFilter(filter);
        constraint.setExtents(extents);
        return constraint;
    }

    public LayerFeatureConstraints createLayerFeatureConstraints(FeatureTypeConstraint[] featureTypeConstraints) {
        LayerFeatureConstraintsImpl constraints = new LayerFeatureConstraintsImpl();
        constraints.setFeatureTypeConstraints(featureTypeConstraints);
        return constraints;
    }

    public FeatureTypeStyle createFeatureTypeStyle() {
        return new FeatureTypeStyleImpl();
    }

    public FeatureTypeStyle createFeatureTypeStyle(Rule[] rules) {
        return new FeatureTypeStyleImpl(rules);
    }

    public Rule createRule() {
        return new RuleImpl();
    }

    public ImageOutline createImageOutline(Symbolizer symbolizer) {
        ImageOutlineImpl outline = new ImageOutlineImpl();
        outline.setSymbolizer(symbolizer);
        return outline;
    }

    public Stroke createStroke(Expression color, Expression width) {
        return this.createStroke(color, width, (Expression)this.filterFactory.literal(1.0));
    }

    public Stroke createStroke(Expression color, Expression width, Expression opacity) {
        return this.createStroke(color, width, opacity, (Expression)this.filterFactory.literal((Object)"miter"), (Expression)this.filterFactory.literal((Object)"butt"), null, (Expression)this.filterFactory.literal(0.0), null, null);
    }

    public Stroke createStroke(Expression color, Expression width, Expression opacity, Expression lineJoin, Expression lineCap, float[] dashArray, Expression dashOffset, Graphic graphicFill, Graphic graphicStroke) {
        StrokeImpl stroke = new StrokeImpl();
        if (color == null) {
            color = Stroke.DEFAULT.getColor();
        }
        stroke.setColor(color);
        if (width == null) {
            width = Stroke.DEFAULT.getWidth();
        }
        stroke.setWidth(width);
        if (opacity == null) {
            opacity = Stroke.DEFAULT.getOpacity();
        }
        stroke.setOpacity(opacity);
        if (lineJoin == null) {
            lineJoin = Stroke.DEFAULT.getLineJoin();
        }
        stroke.setLineJoin(lineJoin);
        if (lineCap == null) {
            lineCap = Stroke.DEFAULT.getLineCap();
        }
        stroke.setLineCap(lineCap);
        stroke.setDashArray(dashArray);
        stroke.setDashOffset(dashOffset);
        stroke.setGraphicFill(graphicFill);
        stroke.setGraphicStroke(graphicStroke);
        return stroke;
    }

    public Fill createFill(Expression color, Expression backgroundColor, Expression opacity, Graphic graphicFill) {
        FillImpl fill = new FillImpl();
        if (color == null) {
            color = Fill.DEFAULT.getColor();
        }
        fill.setColor(color);
        if (backgroundColor == null) {
            backgroundColor = Fill.DEFAULT.getBackgroundColor();
        }
        fill.setBackgroundColor(backgroundColor);
        if (opacity == null) {
            opacity = Fill.DEFAULT.getOpacity();
        }
        fill.setOpacity(opacity);
        fill.setGraphicFill(graphicFill);
        return fill;
    }

    public Fill createFill(Expression color, Expression opacity) {
        return this.createFill(color, null, opacity, null);
    }

    public Fill createFill(Expression color) {
        return this.createFill(color, null, (Expression)this.filterFactory.literal(1.0), null);
    }

    public Mark createMark(Expression wellKnownName, Stroke stroke, Fill fill, Expression size, Expression rotation) {
        MarkImpl mark = new MarkImpl();
        if (wellKnownName == null) {
            throw new IllegalArgumentException("WellKnownName can not be null in mark");
        }
        mark.setWellKnownName(wellKnownName);
        mark.setStroke(stroke);
        mark.setFill(fill);
        if (size == null) {
            throw new IllegalArgumentException("Size can not be null in mark");
        }
        mark.setSize(size);
        if (rotation == null) {
            throw new IllegalArgumentException("Rotation can not be null in mark");
        }
        mark.setRotation(rotation);
        return mark;
    }

    public Mark getSquareMark() {
        Mark mark = this.createMark((Expression)this.filterFactory.literal((Object)"Square"), this.getDefaultStroke(), this.getDefaultFill(), (Expression)this.filterFactory.literal(6), (Expression)this.filterFactory.literal(0));
        return mark;
    }

    public Mark getCircleMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"Circle"));
        return mark;
    }

    public Mark getCrossMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"Cross"));
        return mark;
    }

    public Mark getXMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"X"));
        return mark;
    }

    public Mark getTriangleMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"Triangle"));
        return mark;
    }

    public Mark getStarMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)this.filterFactory.literal((Object)"Star"));
        return mark;
    }

    public Mark createMark() {
        MarkImpl mark = new MarkImpl();
        return mark;
    }

    public Graphic createGraphic(ExternalGraphic[] externalGraphics, Mark[] marks, Symbol[] symbols, Expression opacity, Expression size, Expression rotation) {
        GraphicImpl graphic = new GraphicImpl();
        symbols = symbols != null ? symbols : new Symbol[]{};
        graphic.setSymbols(symbols);
        externalGraphics = externalGraphics != null ? externalGraphics : new ExternalGraphic[]{};
        graphic.setExternalGraphics(externalGraphics);
        marks = marks != null ? marks : new Mark[]{};
        graphic.setMarks(marks);
        if (opacity == null) {
            opacity = Graphic.DEFAULT.getOpacity();
        }
        graphic.setOpacity(opacity);
        if (size == null) {
            size = Graphic.DEFAULT.getSize();
        }
        graphic.setSize(size);
        if (rotation == null) {
            rotation = Graphic.DEFAULT.getRotation();
        }
        graphic.setRotation(rotation);
        return graphic;
    }

    public ExternalGraphic createExternalGraphic(String uri, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setURI(uri);
        extg.setFormat(format);
        return extg;
    }

    public ExternalGraphic createExternalGraphic(URL url, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setLocation(url);
        extg.setFormat(format);
        return extg;
    }

    public Font createFont(Expression fontFamily, Expression fontStyle, Expression fontWeight, Expression fontSize) {
        FontImpl font = new FontImpl();
        if (fontFamily == null) {
            throw new IllegalArgumentException("Null font family specified");
        }
        font.setFontFamily(fontFamily);
        if (fontSize == null) {
            throw new IllegalArgumentException("Null font size specified");
        }
        font.setFontSize(fontSize);
        if (fontStyle == null) {
            throw new IllegalArgumentException("Null font Style specified");
        }
        font.setFontStyle(fontStyle);
        if (fontWeight == null) {
            throw new IllegalArgumentException("Null font weight specified");
        }
        font.setFontWeight(fontWeight);
        return font;
    }

    public LinePlacement createLinePlacement(Expression offset) {
        LinePlacementImpl linep = new LinePlacementImpl();
        linep.setPerpendicularOffset(offset);
        return linep;
    }

    public PointPlacement createPointPlacement(AnchorPoint anchorPoint, Displacement displacement, Expression rotation) {
        PointPlacementImpl pointp = new PointPlacementImpl();
        pointp.setAnchorPoint(anchorPoint);
        pointp.setDisplacement(displacement);
        pointp.setRotation(rotation);
        return pointp;
    }

    public AnchorPoint createAnchorPoint(Expression x, Expression y) {
        AnchorPointImpl anchorPoint = new AnchorPointImpl();
        anchorPoint.setAnchorPointX(x);
        anchorPoint.setAnchorPointY(y);
        return anchorPoint;
    }

    public Displacement createDisplacement(Expression x, Expression y) {
        DisplacementImpl displacement = new DisplacementImpl();
        displacement.setDisplacementX(x);
        displacement.setDisplacementY(y);
        return displacement;
    }

    public Halo createHalo(Fill fill, Expression radius) {
        HaloImpl halo = new HaloImpl();
        halo.setFill(fill);
        halo.setRadius(radius);
        return halo;
    }

    public Fill getDefaultFill() {
        FillImpl fill = new FillImpl();
        try {
            fill.setColor((Expression)this.filterFactory.literal((Object)"#808080"));
            fill.setOpacity((Expression)this.filterFactory.literal((Object)new Double(1.0)));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating fill", ife);
        }
        return fill;
    }

    public LineSymbolizer getDefaultLineSymbolizer() {
        return this.createLineSymbolizer(this.getDefaultStroke(), null);
    }

    public Mark getDefaultMark() {
        return this.getSquareMark();
    }

    public PointSymbolizer getDefaultPointSymbolizer() {
        return this.createPointSymbolizer(this.createDefaultGraphic(), null);
    }

    public PolygonSymbolizer getDefaultPolygonSymbolizer() {
        return this.createPolygonSymbolizer(this.getDefaultStroke(), this.getDefaultFill(), null);
    }

    public Stroke getDefaultStroke() {
        try {
            Stroke stroke = this.createStroke((Expression)this.filterFactory.literal((Object)"#000000"), (Expression)this.filterFactory.literal((Object)new Integer(1)));
            stroke.setDashOffset((Expression)this.filterFactory.literal((Object)new Integer(0)));
            stroke.setDashArray(new float[0]);
            stroke.setLineCap((Expression)this.filterFactory.literal((Object)"butt"));
            stroke.setLineJoin((Expression)this.filterFactory.literal((Object)"miter"));
            stroke.setOpacity((Expression)this.filterFactory.literal((Object)new Integer(1)));
            return stroke;
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating stroke", ife);
        }
    }

    public Style getDefaultStyle() {
        Style style = this.createStyle();
        return style;
    }

    public TextSymbolizer getDefaultTextSymbolizer() {
        return this.createTextSymbolizer(this.getDefaultFill(), new Font[]{this.getDefaultFont()}, null, null, this.getDefaultPointPlacement(), "geometry:text");
    }

    public Font getDefaultFont() {
        return FontImpl.createDefault(this.filterFactory);
    }

    public Graphic createDefaultGraphic() {
        GraphicImpl graphic = new GraphicImpl();
        graphic.setSize(Expression.NIL);
        graphic.setOpacity((Expression)this.filterFactory.literal(1.0));
        graphic.setRotation((Expression)this.filterFactory.literal(0.0));
        return graphic;
    }

    public Graphic getDefaultGraphic() {
        return this.createDefaultGraphic();
    }

    public PointPlacement getDefaultPointPlacement() {
        return this.createPointPlacement(this.createAnchorPoint((Expression)this.filterFactory.literal(0), (Expression)this.filterFactory.literal(0.5)), this.createDisplacement((Expression)this.filterFactory.literal(0), (Expression)this.filterFactory.literal(0)), (Expression)this.filterFactory.literal(0));
    }

    public RasterSymbolizer createRasterSymbolizer() {
        return new RasterSymbolizerImpl();
    }

    public RasterSymbolizer createRasterSymbolizer(String geometryPropertyName, Expression opacity, ChannelSelection channel, Expression overlap, ColorMap colorMap, ContrastEnhancement cenhancement, ShadedRelief relief, Symbolizer outline) {
        RasterSymbolizerImpl rastersym = new RasterSymbolizerImpl();
        if (geometryPropertyName != null) {
            rastersym.setGeometryPropertyName(geometryPropertyName);
        }
        if (opacity != null) {
            rastersym.setOpacity(opacity);
        }
        if (channel != null) {
            rastersym.setChannelSelection(channel);
        }
        if (overlap != null) {
            rastersym.setOverlap(overlap);
        }
        if (colorMap != null) {
            rastersym.setColorMap(colorMap);
        }
        if (cenhancement != null) {
            rastersym.setContrastEnhancement(cenhancement);
        }
        if (relief != null) {
            rastersym.setShadedRelief(relief);
        }
        if (outline != null) {
            rastersym.setImageOutline(outline);
        }
        return rastersym;
    }

    public RasterSymbolizer getDefaultRasterSymbolizer() {
        return this.createRasterSymbolizer("geom", (Expression)this.filterFactory.literal(1.0), null, null, null, null, null, null);
    }

    public ChannelSelection createChannelSelection(SelectedChannelType[] channels) {
        ChannelSelectionImpl channelSel = new ChannelSelectionImpl();
        if (channels != null && channels.length > 0) {
            channelSel.setSelectedChannels(channels);
        }
        return channelSel;
    }

    public ColorMap createColorMap() {
        return new ColorMapImpl();
    }

    public ColorMapEntry createColorMapEntry() {
        return new ColorMapEntryImpl();
    }

    public ContrastEnhancement createContrastEnhancement() {
        return new ContrastEnhancementImpl();
    }

    public ContrastEnhancement createContrastEnhancement(Expression gammaValue) {
        ContrastEnhancementImpl ce = new ContrastEnhancementImpl();
        ce.setGammaValue(gammaValue);
        return ce;
    }

    public SelectedChannelType createSelectedChannelType(String name, ContrastEnhancement enhancement) {
        SelectedChannelTypeImpl sct = new SelectedChannelTypeImpl();
        sct.setChannelName(name);
        sct.setContrastEnhancement(enhancement);
        return sct;
    }

    public SelectedChannelType createSelectedChannelType(String name, Expression gammaValue) {
        SelectedChannelTypeImpl sct = new SelectedChannelTypeImpl();
        sct.setChannelName(name);
        sct.setContrastEnhancement(this.createContrastEnhancement(gammaValue));
        return sct;
    }

    public StyledLayerDescriptor createStyledLayerDescriptor() {
        return new StyledLayerDescriptorImpl();
    }

    public UserLayer createUserLayer() {
        return new UserLayerImpl();
    }

    public NamedLayer createNamedLayer() {
        return new NamedLayerImpl();
    }

    public RemoteOWS createRemoteOWS(String service, String onlineResource) {
        RemoteOWSImpl remoteOWS = new RemoteOWSImpl();
        remoteOWS.setService(service);
        remoteOWS.setOnlineResource(onlineResource);
        return remoteOWS;
    }

    public ShadedRelief createShadedRelief(Expression reliefFactor) {
        ShadedReliefImpl relief = new ShadedReliefImpl();
        relief.setReliefFactor(reliefFactor);
        return relief;
    }
}

