/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.styling.ChannelSelection;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.StyleVisitor;

public class ChannelSelectionImpl
implements ChannelSelection {
    private SelectedChannelType gray;
    private SelectedChannelType red;
    private SelectedChannelType blue;
    private SelectedChannelType green;

    public SelectedChannelType getGrayChannel() {
        return this.gray;
    }

    public SelectedChannelType[] getRGBChannels() {
        return new SelectedChannelType[]{this.red, this.green, this.blue};
    }

    public SelectedChannelType[] getSelectedChannels() {
        SelectedChannelType[] ret = null;
        if (this.gray != null) {
            ret = new SelectedChannelType[]{this.gray};
        } else if (this.red != null || this.green != null || this.blue != null) {
            ret = new SelectedChannelType[]{this.red, this.green, this.blue};
        }
        return ret;
    }

    public void setGrayChannel(SelectedChannelType gray) {
        this.gray = gray;
    }

    public void setRGBChannels(SelectedChannelType[] channels) {
        if (channels.length != 3) {
            throw new IllegalArgumentException("Three channels are required in setRGBChannels, got " + channels.length);
        }
        this.red = channels[0];
        this.green = channels[1];
        this.blue = channels[2];
    }

    public void setRGBChannels(SelectedChannelType red, SelectedChannelType green, SelectedChannelType blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setSelectedChannels(SelectedChannelType[] channels) {
        if (channels.length == 1) {
            this.gray = channels[0];
        } else if (channels.length == 3) {
            this.red = channels[0];
            this.green = channels[1];
            this.blue = channels[2];
        } else {
            throw new IllegalArgumentException("Wrong number of elements in setSelectedChannels, expected 1 or 3, got " + channels.length);
        }
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }
}

