/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundsVisitor
implements FeatureCalc {
    Envelope bounds = new Envelope();

    public void init(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
    }

    @Override
    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        Geometry geom = (Geometry)feature.getDefaultGeometryProperty().getValue();
        Envelope bbox = geom.getEnvelopeInternal();
        this.bounds.expandToInclude(bbox);
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public void reset(Envelope bounds) {
        this.bounds = new Envelope();
    }

    @Override
    public CalcResult getResult() {
        return new BoundsResult(this.bounds);
    }

    public static class BoundsResult
    extends AbstractCalcResult {
        private Envelope bbox;

        public BoundsResult(Envelope bbox) {
            this.bbox = bbox;
        }

        public Object getValue() {
            return new Envelope(this.bbox);
        }

        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof BoundsResult;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd instanceof BoundsResult) {
                Envelope newBounds = new Envelope(this.bbox);
                newBounds.expandToInclude((Envelope)resultsToAdd.getValue());
                return new BoundsResult(newBounds);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

