/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;

public class Point
extends Geometry {
    public double x;
    public double y;
    public double z;

    public Point() {
        this.type = Geometry.POINT;
    }

    public Point(double x, double y, double z) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = 3;
    }

    public Point(double x, double y) {
        this();
        this.x = x;
        this.y = y;
        this.z = 0.0;
        this.dimension = 2;
    }

    public Point(String value) throws SQLException {
        this();
        value = value.trim();
        if (value.indexOf("POINT") == 0) {
            value = value.substring(5).trim();
        }
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara((String)value), ' ');
        try {
            if (t.getSize() == 3) {
                this.x = Double.valueOf(t.getToken(0));
                this.y = Double.valueOf(t.getToken(1));
                this.z = Double.valueOf(t.getToken(2));
                this.dimension = 3;
            } else {
                this.x = Double.valueOf(t.getToken(0));
                this.y = Double.valueOf(t.getToken(1));
                this.z = 0.0;
                this.dimension = 2;
            }
        }
        catch (NumberFormatException e) {
            throw new PSQLException("postgis.Point", (Object)e.toString());
        }
    }

    public String toString() {
        return "POINT (" + this.getValue() + ")";
    }

    public String getValue() {
        if (this.dimension == 3) {
            return this.x + " " + this.y + " " + this.z;
        }
        return this.x + " " + this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }
}

