/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.lang.reflect.Method;
import java.util.Map;
import org.geoserver.ows.util.ClassProperties;
import org.geotools.util.SoftValueHashMap;

public class OwsUtils {
    static Map<Class, ClassProperties> classPropertiesCache = new SoftValueHashMap();

    static ClassProperties classProperties(Class clazz) {
        ClassProperties properties = classPropertiesCache.get(clazz);
        if (properties == null) {
            properties = new ClassProperties(clazz);
            classPropertiesCache.put(clazz, properties);
        }
        return properties;
    }

    public static ClassProperties getClassProperties(Class clazz) {
        return OwsUtils.classProperties(clazz);
    }

    public static void set(Object object, String property, Object value) throws IllegalArgumentException {
        Method s = OwsUtils.setter(object.getClass(), property, value != null ? value.getClass() : null);
        if (s == null) {
            throw new IllegalArgumentException("No such property '" + property + "' for object " + object);
        }
        try {
            s.invoke(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method setter(Class clazz, String property, Class type) {
        return OwsUtils.classProperties(clazz).setter(property, type);
    }

    public static Object get(Object object, String property) {
        Method g = OwsUtils.getter(object.getClass(), property, null);
        if (g == null) {
            throw new IllegalArgumentException("No such property '" + property + "' for object " + object);
        }
        try {
            return g.invoke(object, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getter(Class clazz, String property, Class type) {
        return OwsUtils.classProperties(clazz).getter(property, type);
    }

    public static Object property(Object object, String property, Class type) {
        Method getter = OwsUtils.getter(object.getClass(), property, type);
        if (getter != null) {
            try {
                return getter.invoke(object, null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method method(Class clazz, String name) {
        return OwsUtils.classProperties(clazz).method(name);
    }

    public static Object parameter(Object[] parameters, Class type) {
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter == null || !type.isAssignableFrom(parameter.getClass())) continue;
            return parameter;
        }
        return null;
    }
}

