/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KvpUtils {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests.readers");
    public static final Tokenizer KEYWORD_DELIMITER = new Tokenizer("&");
    public static final Tokenizer VALUE_DELIMITER = new Tokenizer("=");
    public static final Tokenizer OUTER_DELIMETER = new Tokenizer("\\)\\("){

        public List readFlat(String rawList) {
            ArrayList<String> list = new ArrayList<String>(super.readFlat(rawList));
            int len = list.size();
            if (len > 0) {
                String last;
                String first = (String)list.get(0);
                if (first.startsWith("(")) {
                    list.set(0, first.substring(1));
                }
                if ((last = (String)list.get(len - 1)).endsWith(")")) {
                    list.set(len - 1, last.substring(0, last.length() - 1));
                }
            }
            return list;
        }
    };
    public static final Tokenizer INNER_DELIMETER = new Tokenizer(",");
    public static final Tokenizer CQL_DELIMITER = new Tokenizer(";");

    public static List getTypesFromFids(String rawFidList) {
        ArrayList<String> typeList = new ArrayList<String>();
        List unparsed = KvpUtils.readNested(rawFidList);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            List ids = (List)i.next();
            ListIterator innerIterator = ids.listIterator();
            while (innerIterator.hasNext()) {
                String fid = innerIterator.next().toString();
                LOGGER.finer("looking at featureId" + fid);
                String typeName = fid.substring(0, fid.lastIndexOf("."));
                LOGGER.finer("adding typename: " + typeName + " from fid");
                typeList.add(typeName);
            }
        }
        return typeList;
    }

    public static List readFlat(String rawList) {
        return KvpUtils.readFlat(rawList, INNER_DELIMETER);
    }

    public static List readFlat(String rawList, Tokenizer tokenizer) {
        return tokenizer.readFlat(rawList);
    }

    public static List readFlat(String rawList, String delimiter) {
        Tokenizer delim;
        if (KvpUtils.KEYWORD_DELIMITER.getRegExp().equals(delimiter)) {
            delim = KEYWORD_DELIMITER;
        } else if (KvpUtils.VALUE_DELIMITER.getRegExp().equals(delimiter)) {
            delim = VALUE_DELIMITER;
        } else if (KvpUtils.OUTER_DELIMETER.getRegExp().equals(delimiter)) {
            delim = OUTER_DELIMETER;
        } else if (KvpUtils.INNER_DELIMETER.getRegExp().equals(delimiter)) {
            delim = INNER_DELIMETER;
        } else if (KvpUtils.CQL_DELIMITER.getRegExp().equals(delimiter)) {
            delim = CQL_DELIMITER;
        } else {
            LOGGER.fine("Using not a well known kvp tokenization delimiter: " + delimiter);
            delim = new Tokenizer(delimiter);
        }
        return KvpUtils.readFlat(rawList, delim);
    }

    public static List readNested(String rawList) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("reading nested: " + rawList);
        }
        ArrayList<List> kvpList = new ArrayList<List>(10);
        if (rawList == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found implicit all requested");
            }
            kvpList.add(Collections.EMPTY_LIST);
            return kvpList;
        }
        if (rawList.equals("*")) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found explicit all requested");
            }
            kvpList.add(Collections.EMPTY_LIST);
            return kvpList;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("found explicit requested");
        }
        if (rawList.startsWith("(")) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("reading complex list");
            }
            List outerList = KvpUtils.readFlat(rawList, OUTER_DELIMETER);
            ListIterator i = outerList.listIterator();
            while (i.hasNext()) {
                kvpList.add(KvpUtils.readFlat((String)i.next(), INNER_DELIMETER));
            }
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("reading simple list");
            }
            kvpList.add(KvpUtils.readFlat(rawList, INNER_DELIMETER));
        }
        return kvpList;
    }

    public static Map parseKvpSet(String qString) {
        String cleanRequest = KvpUtils.clean(qString);
        LOGGER.fine("clean request is " + cleanRequest);
        HashMap<String, String> kvps = new HashMap<String, String>();
        StringTokenizer requestKeywords = new StringTokenizer(cleanRequest.trim(), KvpUtils.KEYWORD_DELIMITER.getRegExp());
        while (requestKeywords.hasMoreTokens()) {
            String kvpPair = requestKeywords.nextToken();
            if (kvpPair.toUpperCase().startsWith("FILTER")) {
                String filterVal = kvpPair.substring(7);
                LOGGER.finest("putting filter value " + filterVal);
                kvps.put("FILTER", filterVal);
                continue;
            }
            StringTokenizer requestValues = new StringTokenizer(kvpPair, KvpUtils.VALUE_DELIMITER.getRegExp());
            if (!requestValues.hasMoreTokens()) continue;
            String key = requestValues.nextToken().toUpperCase();
            if (!requestValues.hasMoreTokens()) continue;
            String value = requestValues.nextToken();
            LOGGER.finest("putting kvp pair: " + key + ": " + value);
            kvps.put(key, value);
        }
        LOGGER.fine("returning parsed " + kvps);
        return kvps;
    }

    public static String clean(String raw) {
        LOGGER.finest("raw request: " + raw);
        String clean = null;
        if (raw != null) {
            try {
                clean = URLDecoder.decode(raw, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.finer("Bad encoding for decoder " + e);
            }
        } else {
            return "";
        }
        LOGGER.finest("cleaned request: " + raw);
        return clean;
    }

    public static KvpMap normalize(Map kvp) {
        if (kvp == null) {
            return null;
        }
        KvpMap normalizedKvp = new KvpMap();
        for (Map.Entry entry : kvp.entrySet()) {
            String key = (String)entry.getKey();
            String value = null;
            if (entry.getValue() instanceof String) {
                value = (String)entry.getValue();
            } else if (entry.getValue() instanceof String[]) {
                value = ((String[])entry.getValue())[0];
            }
            if (value != null) {
                value = value.trim();
            }
            normalizedKvp.put(key.toLowerCase(), value);
        }
        return normalizedKvp;
    }

    public static List<Throwable> parse(Map kvp) {
        List parsers = GeoServerExtensions.extensions(KvpParser.class);
        String service = (String)kvp.get("service");
        String version = (String)kvp.get("version");
        String request = (String)kvp.get("request");
        Iterator p = parsers.iterator();
        while (p.hasNext()) {
            KvpParser parser = (KvpParser)p.next();
            if (parser.getService() != null && !parser.getService().equalsIgnoreCase(service)) {
                p.remove();
                continue;
            }
            if (parser.getVersion() != null && !parser.getVersion().toString().equals(version)) {
                p.remove();
                continue;
            }
            if (parser.getRequest() == null || parser.getRequest().equalsIgnoreCase(request)) continue;
            p.remove();
        }
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Map.Entry entry : kvp.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Object parsed = null;
            Iterator pitr = parsers.iterator();
            while (pitr.hasNext() && parsed == null) {
                KvpParser parser = (KvpParser)pitr.next();
                if (!key.equalsIgnoreCase(parser.getKey())) continue;
                try {
                    parsed = parser.parse(value);
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
            if (parsed == null) continue;
            entry.setValue(parsed);
        }
        return errors;
    }

    public static class Tokenizer {
        private String regExp;

        public Tokenizer(String regExp) {
            this.regExp = regExp;
        }

        private String getRegExp() {
            return this.regExp;
        }

        public String toString() {
            return this.getRegExp();
        }

        public List readFlat(String rawList) {
            if (rawList == null || rawList.trim().equals("")) {
                return Collections.EMPTY_LIST;
            }
            if (rawList.equals("*")) {
                return Collections.EMPTY_LIST;
            }
            String[] split = rawList.split(this.getRegExp(), -1);
            return new ArrayList<String>(Arrays.asList(split));
        }
    }
}

