/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.geotools.xml.Binding;
import org.geotools.xml.BindingWalkerFactory;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.BindingWalker;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GML2ParsingUtils {
    public static SimpleFeature parseFeature(ElementInstance instance, Node node, Object value, FeatureTypeCache ftCache, BindingWalkerFactory bwFactory) throws Exception {
        String fid;
        XSDElementDeclaration decl = instance.getElementDeclaration();
        SimpleFeatureType fType = null;
        if (!decl.isAbstract()) {
            fType = ftCache.get(new NameImpl(decl.getTargetNamespace(), decl.getName()));
            if (fType == null) {
                fType = GML2ParsingUtils.featureType(decl, bwFactory);
                ftCache.put(fType);
            }
        } else {
            fType = ftCache.get(new NameImpl(node.getComponent().getNamespace(), node.getComponent().getName()));
            if (fType == null) {
                fType = GML2ParsingUtils.featureType(node);
                ftCache.put(fType);
            }
        }
        if ((fid = (String)node.getAttributeValue("fid")) == null) {
            fid = (String)node.getAttributeValue("id");
        }
        return GML2ParsingUtils.feature(fType, fid, node);
    }

    public static SimpleFeatureType featureType(Node node) throws Exception {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(node.getComponent().getName());
        ftBuilder.setNamespaceURI(node.getComponent().getNamespace());
        if (!node.hasChild("description")) {
            ftBuilder.add("description", String.class);
        }
        if (!node.hasChild("name")) {
            ftBuilder.add("name", String.class);
        }
        if (!node.hasChild("boundedBy")) {
            ftBuilder.add("boundedBy", ReferencedEnvelope.class);
        }
        for (Node child : node.getChildren()) {
            String name = child.getComponent().getName();
            Object valu = child.getValue();
            ftBuilder.add(name, valu != null ? valu.getClass() : Object.class);
        }
        return ftBuilder.buildFeatureType();
    }

    public static SimpleFeatureType featureType(XSDElementDeclaration element, BindingWalkerFactory bwFactory) throws Exception {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(element.getName());
        ftBuilder.setNamespaceURI(element.getTargetNamespace());
        List children = Schemas.getChildElementParticles((XSDTypeDefinition)element.getType(), (boolean)true);
        for (XSDParticle particle : children) {
            XSDElementDeclaration property = (XSDElementDeclaration)particle.getContent();
            if (property.isElementDeclarationReference()) {
                property = property.getResolvedElementDeclaration();
            }
            final ArrayList bindings = new ArrayList();
            BindingWalker.Visitor visitor = new BindingWalker.Visitor(){

                public void visit(Binding binding) {
                    bindings.add(binding);
                }
            };
            bwFactory.walk((XSDFeature)property, visitor);
            if (bindings.isEmpty()) {
                throw new RuntimeException("Could not find binding for " + property.getQName());
            }
            Binding last = (Binding)bindings.get(bindings.size() - 1);
            Class theClass = last.getType();
            if (theClass == null) {
                throw new RuntimeException("binding declares null type: " + last.getTarget());
            }
            int min = particle.getMinOccurs();
            int max = particle.getMaxOccurs();
            if (min == -1) {
                min = 0;
            }
            if (max == -1) {
                max = 1;
            }
            ftBuilder.minOccurs(min).maxOccurs(max).add(property.getName(), theClass);
            if (!Geometry.class.isAssignableFrom(theClass) || "http://www.opengis.net/gml".equals(property.getTargetNamespace()) || ftBuilder.getDefaultGeometry() != null) continue;
            ftBuilder.setDefaultGeometry(property.getName());
        }
        return ftBuilder.buildFeatureType();
    }

    public static SimpleFeature feature(SimpleFeatureType fType, String fid, Node node) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(fType);
        Object[] attributes = new Object[fType.getAttributeCount()];
        for (int i = 0; i < fType.getAttributeCount(); ++i) {
            Object converted;
            AttributeDescriptor att = fType.getDescriptor(i);
            AttributeType attType = att.getType();
            Object attValue = node.getChildValue(att.getLocalName());
            if (attValue != null && !attType.getBinding().isAssignableFrom(attValue.getClass()) && (converted = Converters.convert((Object)attValue, (Class)attType.getBinding())) != null) {
                attValue = converted;
            }
            b.add(attValue);
        }
        return b.buildFeature(fid);
    }

    public static CoordinateReferenceSystem crs(Node node) {
        if (node.getAttribute("srsName") != null) {
            URI srs = null;
            Object raw = node.getAttributeValue("srsName");
            if (raw instanceof URI) {
                srs = (URI)raw;
            } else if (raw instanceof String) {
                try {
                    srs = new URI((String)raw);
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            if (srs != null && "http".equals(srs.getScheme()) && "www.opengis.net".equals(srs.getAuthority()) && "/gml/srs/epsg.xml".equals(srs.getPath()) && srs.getFragment() != null) {
                try {
                    return CRS.decode("EPSG:" + srs.getFragment());
                }
                catch (Exception e) {
                    try {
                        return CRS.decode(srs.toString());
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
            }
            try {
                return CRS.decode(raw.toString());
            }
            catch (NoSuchAuthorityCodeException e) {
                String crs = raw.toString();
                if (crs.toUpperCase().startsWith("URN")) {
                    String code = crs.substring(crs.lastIndexOf(":") + 1);
                    try {
                        return CRS.decode("EPSG:" + code);
                    }
                    catch (Exception e1) {
                        throw new RuntimeException("Could not create crs: " + srs, e);
                    }
                }
            }
            catch (FactoryException e) {
                throw new RuntimeException("Could not create crs: " + srs, e);
            }
        }
        return null;
    }

    public static Collection asCollection(GeometryCollection gc) {
        ArrayList<Geometry> members = new ArrayList<Geometry>();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            members.add(gc.getGeometryN(i));
        }
        return members;
    }
}

