/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.opengis.wcs11.GetCoverageType;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.response.CoveragesHandler;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegateFactory;

public class WCSMultipartResponse
extends Response {
    MimeMultipart multipart;
    Data catalog;

    public WCSMultipartResponse(Data catalog) {
        super(GridCoverage[].class);
        this.catalog = catalog;
        this.multipart = new MimeMultipart();
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return this.multipart.getContentType().replace("mixed", "related");
    }

    public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
        GetCoverageType request = (GetCoverageType)operation.getParameters()[0];
        String identifier = request.getIdentifier().getValue();
        return new String[][]{{"Content-Disposition", "attachment;filename=\"" + identifier.replace(':', '_') + ".eml\""}};
    }

    public boolean canHandle(Operation operation) {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        return !getCoverage.getOutput().isStore();
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        GridCoverage[] coverages = (GridCoverage[])value;
        GetCoverageType request = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = request.getOutput().getFormat();
        CoverageResponseDelegate delegate = CoverageResponseDelegateFactory.encoderFor((String)outputFormat);
        if (delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoverageInfo coverageInfo = this.catalog.getCoverageInfo(request.getIdentifier().getValue());
        try {
            MimeBodyPart coveragesPart = new MimeBodyPart();
            CoveragesHandler.CoveragesData coveragesData = new CoveragesHandler.CoveragesData(coverageInfo, request);
            coveragesPart.setDataHandler(new DataHandler((Object)coveragesData, "geoserver/coverages"));
            coveragesPart.setHeader("Content-ID", "<urn:ogc:wcs:1.1:coverages>");
            coveragesPart.setHeader("Content-Type", "text/xml");
            this.multipart.addBodyPart((BodyPart)coveragesPart);
            MimeBodyPart coveragePart = new MimeBodyPart();
            delegate.prepare(outputFormat, coverage);
            coveragePart.setDataHandler(new DataHandler((Object)delegate, "geoserver/coverageDelegate"));
            coveragePart.setHeader("Content-ID", "<theCoverage>");
            coveragePart.setHeader("Content-Type", delegate.getContentType(this.catalog.getGeoServer()));
            coveragePart.setHeader("Content-Transfer-Encoding", "base64");
            this.multipart.addBodyPart((BodyPart)coveragePart);
            GeoServerMimeMessage message = new GeoServerMimeMessage();
            message.setContent((Multipart)this.multipart);
            message.writeTo(output);
            output.flush();
        }
        catch (MessagingException e) {
            throw new WcsException("Error occurred while encoding the mime multipart response", (Throwable)e);
        }
    }

    private static class GeoServerMimeMessage
    extends MimeMessage {
        public GeoServerMimeMessage() {
            super((Session)null);
        }

        protected void updateMessageID() throws MessagingException {
            this.removeHeader("Message-ID");
        }
    }
}

