/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.opengis.wcs11.GetCapabilitiesType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.WCS;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class WCSCapsTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)WCSCapsTransformer.class.getPackage().getName());
    protected static final String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    protected static final String CUR_VERSION = "1.1.1";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private WCS wcs;
    private Data catalog;

    public WCSCapsTransformer(WCS wcs, Data catalog) {
        this.wcs = wcs;
        this.catalog = catalog;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS111CapsTranslator(handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WCS111CapsTranslator
    extends TransformerBase.TranslatorSupport {
        private GetCapabilitiesType request;
        private String proxifiedBaseUrl;

        public WCS111CapsTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            EList sections;
            boolean allSections;
            if (!(o instanceof GetCapabilitiesType)) {
                throw new IllegalArgumentException(new StringBuffer("Not a GetCapabilitiesType: ").append(o).toString());
            }
            this.request = (GetCapabilitiesType)o;
            int updateSequence = WCSCapsTransformer.this.wcs.getGeoServer().getUpdateSequence();
            int requestedUpdateSequence = -1;
            if (this.request.getUpdateSequence() != null) {
                try {
                    requestedUpdateSequence = Integer.parseInt(this.request.getUpdateSequence());
                }
                catch (NumberFormatException e) {
                    throw new WcsException("Invalid update sequence number format, should be an integer", WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
                if (requestedUpdateSequence > updateSequence) {
                    throw new WcsException("Invalid update sequence value, it's higher than the current value, " + updateSequence, WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", WCSCapsTransformer.CUR_VERSION);
            attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", WCSCapsTransformer.WCS_URI);
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = new StringBuffer("xmlns:").append(WCSCapsTransformer.XSI_PREFIX).toString();
            attributes.addAttribute("", prefixDef, prefixDef, "", WCSCapsTransformer.XSI_URI);
            String locationAtt = new StringBuffer(WCSCapsTransformer.XSI_PREFIX).append(":schemaLocation").toString();
            this.proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)WCSCapsTransformer.this.wcs.getGeoServer().getProxyBaseUrl());
            String locationDef = "http://www.opengis.net/wcs/1.1.1 " + this.proxifiedBaseUrl + "schemas/wcs/1.1.1/wcsGetCapabilities.xsd";
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "updateSequence", "updateSequence", "", String.valueOf(updateSequence));
            this.start("wcs:Capabilities", attributes);
            if (this.request.getSections() == null) {
                allSections = true;
                sections = Collections.emptyList();
            } else {
                sections = this.request.getSections().getSection();
                allSections = sections.contains("All");
            }
            HashSet<String> knownSections = new HashSet<String>(Arrays.asList("ServiceIdentification", "ServiceProvider", "OperationsMetadata", "Contents", "All"));
            for (String section : sections) {
                if (knownSections.contains(section)) continue;
                throw new WcsException("Unknown section " + section, WcsException.WcsExceptionCode.InvalidParameterValue, "Sections");
            }
            if (requestedUpdateSequence < updateSequence) {
                if (allSections || sections.contains("ServiceIdentification")) {
                    this.handleServiceIdentification();
                }
                if (allSections || sections.contains("ServiceProvider")) {
                    this.handleServiceProvider();
                }
                if (allSections || sections.contains("OperationsMetadata")) {
                    this.handleOperationsMetadata();
                }
                if (allSections || sections.contains("Contents")) {
                    this.handleContents();
                }
            }
            this.end("wcs:Capabilities");
        }

        private void handleServiceIdentification() {
            this.start("ows:ServiceIdentification");
            this.element("ows:Title", WCSCapsTransformer.this.wcs.getTitle());
            this.element("ows:Abstract", WCSCapsTransformer.this.wcs.getAbstract());
            this.handleKeywords(WCSCapsTransformer.this.wcs.getKeywords());
            this.element("ows:ServiceType", "WCS");
            this.element("ows:ServiceTypeVersion", "1.1.0");
            this.element("ows:ServiceTypeVersion", WCSCapsTransformer.CUR_VERSION);
            String fees = WCSCapsTransformer.this.wcs.getFees();
            if (fees == null || "".equals(fees)) {
                fees = "NONE";
            }
            this.element("ows:Fees", fees);
            String accessConstraints = WCSCapsTransformer.this.wcs.getAccessConstraints();
            if (accessConstraints == null || "".equals(accessConstraints)) {
                accessConstraints = "NONE";
            }
            this.element("ows:AccessConstraints", accessConstraints);
            this.end("ows:ServiceIdentification");
        }

        private void handleServiceProvider() {
            this.start("ows:ServiceProvider");
            this.element("ows:ProviderName", WCSCapsTransformer.this.wcs.getGeoServer().getContactOrganization());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", WCSCapsTransformer.this.wcs.getGeoServer().getOnlineResource());
            this.element("ows:ProviderSite", null, attributes);
            this.handleContact();
            this.end("ows:ServiceProvider");
        }

        private void handleOperationsMetadata() {
            this.start("ows:OperationsMetadata");
            this.handleOperation("GetCapabilities", null);
            this.handleOperation("DescribeCoverage", null);
            this.handleOperation("GetCoverage", (Map<String, List<String>>)new HashMap<String, List<String>>(){
                {
                    this.put("store", Arrays.asList("True", "False"));
                }
            });
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "name", "name", null, "PostEncoding");
            this.start("ows:Constraint", attributes);
            this.start("ows:AllowedValues");
            this.element("ows:Value", "XML");
            this.end("ows:AllowedValues");
            this.end("ows:Constraint");
            this.end("ows:OperationsMetadata");
        }

        private void handleOperation(String capabilityName, Map<String, List<String>> parameters) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "name", "name", null, capabilityName);
            this.start("ows:Operation", attributes);
            String url = this.proxifiedBaseUrl + "wcs?";
            this.start("ows:DCP");
            this.start("ows:HTTP");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.element("ows:Get", null, attributes);
            this.end("ows:HTTP");
            this.end("ows:DCP");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.start("ows:DCP");
            this.start("ows:HTTP");
            this.element("ows:Post", null, attributes);
            this.end("ows:HTTP");
            this.end("ows:DCP");
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, List<String>> param : parameters.entrySet()) {
                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "name", "name", "", param.getKey());
                    this.start("ows:Parameter", attributes);
                    this.start("ows:AllowedValues");
                    for (String value : param.getValue()) {
                        this.element("ows:Value", value);
                    }
                    this.end("ows:AllowedValues");
                    this.end("ows:Parameter");
                }
            }
            this.end("ows:Operation");
        }

        private void handleKeywords(List kwords) {
            this.start("ows:Keywords");
            if (kwords != null) {
                Iterator it = kwords.iterator();
                while (it.hasNext()) {
                    this.element("ows:Keyword", it.next().toString());
                }
            }
            this.end("ows:Keywords");
        }

        private void handleContact() {
            GeoServer gs = WCSCapsTransformer.this.wcs.getGeoServer();
            this.start("ows:ServiceContact");
            this.elementIfNotEmpty("ows:IndividualName", gs.getContactPerson());
            this.elementIfNotEmpty("ows:PositionName", gs.getContactPosition());
            this.start("ows:ContactInfo");
            this.start("ows:Phone");
            this.elementIfNotEmpty("ows:Voice", gs.getContactVoice());
            this.elementIfNotEmpty("ows:Facsimile", gs.getContactFacsimile());
            this.end("ows:Phone");
            this.start("ows:Address");
            this.elementIfNotEmpty("ows:DeliveryPoint", gs.getAddress());
            this.elementIfNotEmpty("ows:City", gs.getAddressCity());
            this.elementIfNotEmpty("ows:AdministrativeArea", gs.getAddressState());
            this.elementIfNotEmpty("ows:PostalCode", gs.getAddressPostalCode());
            this.elementIfNotEmpty("ows:Country", gs.getAddressCountry());
            this.elementIfNotEmpty("ows:ElectronicMailAddress", gs.getContactEmail());
            this.end("ows:Address");
            String or = gs.getOnlineResource();
            if (or != null && !"".equals(or.trim())) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "xlink:href", "xlink:href", "", or);
                this.start("ows:OnlineResource", attributes);
                this.end("OnlineResource");
            }
            this.end("ows:ContactInfo");
            this.end("ows:ServiceContact");
        }

        private void handleEnvelope(GeneralEnvelope envelope) {
            this.start("ows:WGS84BoundingBox");
            this.element("ows:LowerCorner", new StringBuffer(Double.toString(envelope.getLowerCorner().getOrdinate(0))).append(" ").append(envelope.getLowerCorner().getOrdinate(1)).toString());
            this.element("ows:UpperCorner", new StringBuffer(Double.toString(envelope.getUpperCorner().getOrdinate(0))).append(" ").append(envelope.getUpperCorner().getOrdinate(1)).toString());
            this.end("ows:WGS84BoundingBox");
        }

        private void handleContents() {
            this.start("wcs:Contents");
            ArrayList coverages = new ArrayList(WCSCapsTransformer.this.wcs.getData().getCoverageInfos().values());
            Iterator it = coverages.iterator();
            while (it.hasNext()) {
                CoverageInfo cv = (CoverageInfo)it.next();
                if (cv.isEnabled()) continue;
                it.remove();
            }
            if (this.request.getNamespace() != null) {
                String namespace = this.request.getNamespace();
                Iterator it2 = coverages.iterator();
                while (it2.hasNext()) {
                    CoverageInfo cv = (CoverageInfo)it2.next();
                    if (namespace.equals(cv.getNameSpace().getPrefix())) continue;
                    it2.remove();
                }
            }
            Collections.sort(coverages, new CoverageInfoLabelComparator());
            for (CoverageInfo cv : coverages) {
                if (!cv.isEnabled()) continue;
                this.handleCoverageSummary(cv);
            }
            this.end("wcs:Contents");
        }

        private void handleCoverageSummary(CoverageInfo cv) {
            this.start("wcs:CoverageSummary");
            this.elementIfNotEmpty("ows:Title", cv.getLabel());
            this.elementIfNotEmpty("ows:Abstract", cv.getDescription());
            this.handleKeywords(cv.getKeywords());
            this.handleMetadataLink(cv.getMetadataLink(), "simple");
            this.handleEnvelope(cv.getWGS84LonLatEnvelope());
            this.element("wcs:Identifier", cv.getName());
            this.end("wcs:CoverageSummary");
        }

        private void handleMetadataLink(MetaDataLink mdl, String linkType) {
            if (mdl != null) {
                AttributesImpl attributes = new AttributesImpl();
                if (mdl.getAbout() != null && mdl.getAbout() != "") {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                if (mdl.getMetadataType() != null && mdl.getMetadataType() != "") {
                    attributes.addAttribute("", "xlink:type", "xlink:type", "", linkType);
                }
                if (attributes.getLength() > 0) {
                    this.element("ows:Metadata", null, attributes);
                }
            }
        }

        private void elementIfNotEmpty(String elementName, String content) {
            if (content != null && !"".equals(content.trim())) {
                this.element(elementName, content);
            }
        }
    }
}

