/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.opengis.ows11.ExceptionReportType;
import net.opengis.ows11.ExceptionType;
import net.opengis.ows11.Ows11Factory;
import org.geoserver.ows.Request;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.ows.v1_1.OWS;
import org.geotools.ows.v1_1.OWSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

public class OWS11ServiceExceptionHandler
extends ServiceExceptionHandler {
    protected boolean verboseExceptions = false;

    public OWS11ServiceExceptionHandler() {
        super(Collections.EMPTY_LIST);
    }

    public OWS11ServiceExceptionHandler(List services) {
        super(services);
    }

    public OWS11ServiceExceptionHandler(Service service) {
        super(Arrays.asList(service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleServiceException(ServiceException exception, Request request) {
        Ows11Factory factory = Ows11Factory.eINSTANCE;
        ExceptionType e = factory.createExceptionType();
        if (exception.getCode() != null) {
            e.setExceptionCode(exception.getCode());
        } else {
            e.setExceptionCode("NoApplicableCode");
        }
        e.setLocator(exception.getLocator());
        StringBuffer sb = new StringBuffer();
        this.dumpExceptionMessages(exception, sb, true);
        e.getExceptionText().add((Object)sb.toString());
        e.getExceptionText().addAll((Collection)exception.getExceptionText());
        if (this.verboseExceptions) {
            e.getExceptionText().add((Object)"Details:");
            ByteArrayOutputStream trace = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(trace));
            e.getExceptionText().add((Object)new String(trace.toByteArray()));
        }
        ExceptionReportType report = factory.createExceptionReportType();
        report.setVersion("1.1.0");
        report.getException().add((Object)e);
        HttpServletResponse response = request.getHttpResponse();
        response.setContentType("application/xml");
        OWSConfiguration configuration = new OWSConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration, configuration.schema());
        encoder.setIndenting(true);
        encoder.setIndentSize(2);
        encoder.setLineWidth(60);
        encoder.setSchemaLocation("http://www.opengis.net/ows/1.1", RequestUtils.schemaBaseURL((HttpServletRequest)request.getHttpRequest()) + "ows/1.1.0/owsAll.xsd");
        try {
            encoder.encode((Object)report, OWS.ExceptionReport, (OutputStream)response.getOutputStream());
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", ex);
        }
        finally {
            try {
                response.getOutputStream().flush();
            }
            catch (IOException ioe) {}
        }
    }
}

