/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;
import org.geotools.ows.ServiceException;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.GridCalculator;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.util.Configuration;
import org.geowebcache.util.ConfigurationException;
import org.geowebcache.util.wms.BBOX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCapabilitiesConfiguration
implements Configuration {
    private static Log log = LogFactory.getLog(GetCapabilitiesConfiguration.class);
    private String url = null;
    private String mimeTypes = null;
    private String metaTiling = null;
    private String vendorParameters = null;
    private boolean allowCacheBypass = false;

    public GetCapabilitiesConfiguration(String url, String mimeTypes, String metaTiling, String allowCacheBypass) {
        this.url = url;
        this.mimeTypes = mimeTypes;
        this.metaTiling = metaTiling;
        if (Boolean.parseBoolean(allowCacheBypass)) {
            this.allowCacheBypass = true;
        }
        log.info((Object)("Constructing from url " + url));
    }

    public GetCapabilitiesConfiguration(String url, String mimeTypes, String metaTiling, String vendorParameters, String allowCacheBypass) {
        this.url = url;
        this.mimeTypes = mimeTypes;
        this.metaTiling = metaTiling;
        this.vendorParameters = vendorParameters;
        if (Boolean.parseBoolean(allowCacheBypass)) {
            this.allowCacheBypass = true;
        }
        log.info((Object)("Constructing from url " + url));
    }

    @Override
    public String getIdentifier() {
        return this.url;
    }

    @Override
    public List<TileLayer> getTileLayers(boolean reload) throws GeoWebCacheException {
        List<TileLayer> layers = null;
        WebMapServer wms = this.getWMS();
        if (wms == null) {
            throw new ConfigurationException("Unable to connect to " + this.url);
        }
        String wmsUrl = this.getWMSUrl(wms);
        log.info((Object)("Using " + wmsUrl + " to generate URLs for WMS requests"));
        layers = this.getLayers(wms, wmsUrl);
        if (layers == null || layers.size() < 1) {
            log.error((Object)("Unable to find any layers based on " + this.url));
        } else {
            log.info((Object)("Loaded " + layers.size() + " layers from " + this.url));
        }
        return layers;
    }

    private String getWMSUrl(WebMapServer wms) {
        int queryStart;
        String wmsUrl = wms.getCapabilities().getRequest().getGetCapabilities().getGet().toString();
        String preQuery = wmsUrl.substring(queryStart = wmsUrl.lastIndexOf("?"));
        if (preQuery.equalsIgnoreCase("?service=wms&")) {
            wmsUrl = wmsUrl.substring(0, wmsUrl.lastIndexOf("?"));
        }
        return wmsUrl;
    }

    private List<TileLayer> getLayers(WebMapServer wms, String wmsUrl) throws GeoWebCacheException {
        LinkedList<TileLayer> layers = new LinkedList<TileLayer>();
        WMSCapabilities capabilities = wms.getCapabilities();
        if (capabilities == null) {
            throw new ConfigurationException("Unable to get capabitilies from " + wmsUrl);
        }
        List layerList = capabilities.getLayerList();
        for (Layer layer : layerList) {
            String name = layer.getName();
            String stylesStr = "";
            if (name == null) continue;
            List styles = layer.getStyles();
            StringBuffer buf = new StringBuffer();
            if (styles != null) {
                Iterator iter = styles.iterator();
                boolean hasOne = false;
                while (iter.hasNext()) {
                    if (hasOne) {
                        buf.append(",");
                    }
                    buf.append(((StyleImpl)iter.next()).getName());
                    hasOne = true;
                }
                stylesStr = buf.toString();
            }
            double minX = layer.getLatLonBoundingBox().getMinX();
            double minY = layer.getLatLonBoundingBox().getMinY();
            double maxX = layer.getLatLonBoundingBox().getMaxX();
            double maxY = layer.getLatLonBoundingBox().getMaxY();
            BBOX bounds4326 = new BBOX(minX, minY, maxX, maxY);
            log.info((Object)("Found layer: " + layer.getName() + " with LatLon bbox " + bounds4326.toString()));
            BBOX bounds900913 = new BBOX(this.longToSphericalMercatorX(minX), this.latToSphericalMercatorY(minY), this.longToSphericalMercatorX(maxX), this.latToSphericalMercatorY(maxY));
            String[] wmsUrls = new String[]{wmsUrl};
            WMSLayer wmsLayer = null;
            try {
                wmsLayer = this.getLayer(name, wmsUrls, bounds4326, bounds900913, stylesStr);
            }
            catch (GeoWebCacheException gwc) {
                log.error((Object)("Error creating " + layer.getName() + ": " + gwc.getMessage()));
            }
            if (wmsLayer == null) continue;
            wmsLayer.isCacheBypassAllowed(this.allowCacheBypass);
            wmsLayer.setBackendTimeout(120);
            layers.add(wmsLayer);
        }
        return layers;
    }

    private WMSLayer getLayer(String name, String[] wmsurl, BBOX bounds4326, BBOX bounds900913, String stylesStr) throws GeoWebCacheException {
        Hashtable<SRS, Grid> grids = new Hashtable<SRS, Grid>(2);
        grids.put(SRS.getEPSG4326(), new Grid(SRS.getEPSG4326(), bounds4326, BBOX.WORLD4326, GridCalculator.get4326Resolutions()));
        grids.put(SRS.getEPSG900913(), new Grid(SRS.getEPSG900913(), bounds900913, BBOX.WORLD900913, GridCalculator.get900913Resolutions()));
        ArrayList<String> mimeFormats = null;
        if (this.mimeTypes != null) {
            String[] mimeFormatArray = this.mimeTypes.split(",");
            mimeFormats = new ArrayList(mimeFormatArray.length);
            for (int i = 0; i < mimeFormatArray.length; ++i) {
                mimeFormats.add(mimeFormatArray[i]);
            }
        } else {
            mimeFormats = new ArrayList<String>(3);
            mimeFormats.add("image/png");
            mimeFormats.add("image/png8");
            mimeFormats.add("image/jpeg");
        }
        String[] metaStrings = this.metaTiling.split("x");
        int[] metaWidthHeight = new int[]{Integer.parseInt(metaStrings[0]), Integer.parseInt(metaStrings[1])};
        return new WMSLayer(name, wmsurl, stylesStr, name, mimeFormats, grids, metaWidthHeight, this.vendorParameters);
    }

    private WebMapServer getWMS() {
        try {
            return new WebMapServer(new URL(this.url));
        }
        catch (IOException ioe) {
            log.error((Object)(this.url + " -> " + ioe.getMessage()));
        }
        catch (ServiceException se) {
            log.error((Object)se.getMessage());
        }
        return null;
    }

    private double longToSphericalMercatorX(double x) {
        return x / 180.0 * 2.003750834E7;
    }

    private double latToSphericalMercatorY(double y) {
        if (y > 85.05112) {
            y = 85.05112;
        }
        if (y < -85.05112) {
            y = -85.05112;
        }
        y = Math.PI / 180 * y;
        double tmp = 0.7853981633974483 + y / 2.0;
        return 2.003750834E7 * Math.log(Math.tan(tmp)) / Math.PI;
    }
}

