/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.WFSObject;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.geowebcache.util.ServletUtils;

public class FileBlobStore
implements BlobStore {
    private static Log log = LogFactory.getLog(FileBlobStore.class);
    public static final int BUFFER_SIZE = 32768;
    private final String path;

    public FileBlobStore(DefaultStorageFinder defStoreFinder) throws StorageException {
        this.path = defStoreFinder.getDefaultPath();
    }

    public FileBlobStore(String rootPath) throws StorageException {
        this.path = rootPath;
        File fh = new File(this.path);
        if (!(fh.exists() && fh.isDirectory() && fh.canWrite())) {
            throw new StorageException(this.path + " is not writable a writable directory.");
        }
    }

    public boolean delete(TileObject stObj) throws StorageException {
        File fh = this.getFileHandleTile(stObj, false);
        if (!fh.exists()) {
            return false;
        }
        if (!fh.delete()) {
            throw new StorageException("Unable to delete " + fh.getAbsolutePath());
        }
        return true;
    }

    public boolean delete(WFSObject stObj) throws StorageException {
        File fh;
        if (stObj.getQueryBlobSize() != -1 && (fh = this.getFileHandleWFS(stObj, true, false)).exists() && !fh.delete()) {
            throw new StorageException("Unable to delete " + fh.getAbsolutePath());
        }
        fh = this.getFileHandleWFS(stObj, false, false);
        if (!fh.exists()) {
            return false;
        }
        if (!fh.delete()) {
            throw new StorageException("Unable to delete " + fh.getAbsolutePath());
        }
        return true;
    }

    public byte[] get(TileObject stObj) throws StorageException {
        File fh = this.getFileHandleTile(stObj, false);
        return this.readFile(fh);
    }

    public long get(WFSObject stObj) throws StorageException {
        File fh = this.getFileHandleWFS(stObj, false, false);
        stObj.setInputStream(this.getFileInputStream(fh));
        return fh.length();
    }

    public void put(TileObject stObj) throws StorageException {
        File fh = this.getFileHandleTile(stObj, true);
        this.writeFile(fh, stObj.getBlob());
    }

    public void put(WFSObject stObj) throws StorageException {
        if (stObj.getQueryBlobSize() != -1) {
            File queryfh = this.getFileHandleWFS(stObj, true, true);
            this.writeFile(queryfh, stObj.getQueryBlob());
        }
        File responsefh = this.getFileHandleWFS(stObj, false, true);
        this.writeFile(responsefh, stObj.getInputStream());
        InputStream is = this.getFileInputStream(responsefh);
        stObj.setInputStream(is);
    }

    private File getFileHandleTile(TileObject stObj, boolean create) {
        String[] paths = null;
        try {
            paths = FilePathGenerator.tilePath(this.path, stObj.getLayerName(), stObj.getXYZ(), stObj.getSrs(), MimeType.createFromFormat(stObj.getBlobFormat()), stObj.getParametersId());
        }
        catch (MimeException me) {
            log.error((Object)me.getMessage());
        }
        if (create) {
            File parent = new File((String)paths[0]);
            parent.mkdirs();
        }
        return new File(paths[0] + File.separator + paths[1]);
    }

    private File getFileHandleWFS(WFSObject stObj, boolean query, boolean create) {
        String parentPath = query ? this.path + File.separator + "wfs" + File.separator + "query" : this.path + File.separator + "wfs" + File.separator + "response";
        if (create) {
            File dir = new File(parentPath);
            dir.mkdirs();
        }
        return new File(parentPath + File.separator + stObj.getId());
    }

    private byte[] readFile(File fh) throws StorageException {
        FileInputStream fis;
        byte[] blob = null;
        try {
            fis = new FileInputStream(fh);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            blob = ServletUtils.readStream(fis, 32768, 32768);
        }
        catch (IOException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + fh.getAbsolutePath());
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                throw new StorageException(ioe.getMessage() + " for " + fh.getAbsolutePath());
            }
        }
        return blob;
    }

    private InputStream getFileInputStream(File fh) throws StorageException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fh);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return fis;
    }

    private void writeFile(File fh, byte[] blob) throws StorageException {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(fh);
        }
        catch (FileNotFoundException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + fh.getAbsolutePath());
        }
        try {
            fos.write(blob);
        }
        catch (IOException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + fh.getAbsolutePath());
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ioe) {
                throw new StorageException(ioe.getMessage() + " for " + fh.getAbsolutePath());
            }
        }
    }

    private int writeFile(File fh, InputStream is) throws StorageException {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(fh);
        }
        catch (FileNotFoundException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + fh.getAbsolutePath());
        }
        byte[] buffer = new byte[2048];
        int read = 0;
        int total = 0;
        try {
            while (read != -1) {
                read = is.read(buffer);
                if (read == -1) continue;
                fos.write(buffer, 0, read);
                total += read;
            }
        }
        catch (IOException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + fh.getAbsolutePath());
        }
        finally {
            try {
                fos.close();
                is.close();
            }
            catch (IOException ioe) {
                throw new StorageException(ioe.getMessage() + " for " + fh.getAbsolutePath());
            }
        }
        return read;
    }

    public void clear() throws StorageException {
        throw new StorageException("Not implemented yet!");
    }

    public void destroy() {
    }
}

