/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.GridCalculator;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.storage.StorageBroker;

public class TruncateTask
extends GWCTask {
    private static Log log = LogFactory.getLog(TruncateTask.class);
    private final SeedRequest req;
    private final TileLayer tl;
    private final StorageBroker storageBroker;
    private static final double[] nullBbox = new double[]{0.0, 0.0, 0.0, 0.0};

    public TruncateTask(StorageBroker sb, SeedRequest req, TileLayer tl) {
        this.storageBroker = sb;
        this.req = req;
        this.tl = tl;
        this.type = 2;
        this.layerName = tl.getName();
        this.tilesTotal = 0L;
        this.timeRemaining = 0L;
        this.timeSpent = 0L;
        this.tilesDone = 0L;
    }

    public void doAction() throws GeoWebCacheException {
        this.tl.isInitialized();
        int[][] bounds = null;
        if (this.req.getBounds() == null) {
            bounds = this.tl.getCoveredGridLevels(this.req.getSRS(), this.tl.getGrid(this.req.getSRS()).getBounds());
        } else if (!Arrays.equals(this.req.getBounds().coords, nullBbox)) {
            bounds = this.tl.getCoveredGridLevels(this.req.getSRS(), this.req.getBounds());
        }
        MimeType[] mimeTypes = null;
        if (this.req.getMimeFormat() != null && this.req.getMimeFormat().length() > 0) {
            MimeType mimeType = MimeType.createFromFormat(this.req.getMimeFormat());
            if (mimeType == XMLMime.kml) {
                mimeTypes = new MimeType[]{mimeType, XMLMime.kmz};
                log.info((Object)"Truncate request was for KML. This will also truncate all KMZ archives.");
            } else {
                mimeTypes = new MimeType[]{mimeType};
            }
            if (bounds != null) {
                int[] metaFactors = this.tl.getMetaTilingFactors();
                int[][] gridBounds = this.tl.getGrid(this.req.getSRS()).getGridCalculator().getGridBounds();
                if (metaFactors[0] > 1 || metaFactors[1] > 1 && mimeType.supportsTiling()) {
                    bounds = GridCalculator.expandBoundsToMetaTiles(gridBounds, bounds, metaFactors);
                }
            }
        }
        log.fatal((Object)"Truncation not implemented!");
    }
}

