/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class IdentityTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -5339040282922138164L;
    private final int dimension;
    private static final LinearTransform[] POOL = new LinearTransform[8];

    protected IdentityTransform(int dimension) {
        this.dimension = dimension;
    }

    public static synchronized LinearTransform create(int dimension) {
        LinearTransform candidate;
        if (dimension < POOL.length && (candidate = POOL[dimension]) != null) {
            return candidate;
        }
        switch (dimension) {
            case 1: {
                candidate = LinearTransform1D.IDENTITY;
                break;
            }
            case 2: {
                candidate = new AffineTransform2D(new AffineTransform());
                break;
            }
            default: {
                candidate = new IdentityTransform(dimension);
            }
        }
        if (dimension < POOL.length) {
            IdentityTransform.POOL[dimension] = candidate;
        }
        return candidate;
    }

    public boolean isIdentity() {
        return true;
    }

    public boolean isIdentity(double tolerance) {
        return true;
    }

    public int getSourceDimensions() {
        return this.dimension;
    }

    public int getTargetDimensions() {
        return this.dimension;
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return ProjectiveTransform.ProviderAffine.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    public Matrix getMatrix() {
        return MatrixFactory.create(this.dimension + 1);
    }

    public Matrix derivative(DirectPosition point) {
        return MatrixFactory.create(this.dimension);
    }

    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) {
        if (ptSrc.getDimension() == this.dimension) {
            if (ptDst == null) {
                return new GeneralDirectPosition(ptSrc);
            }
            if (ptDst.getDimension() == this.dimension) {
                for (int i = 0; i < this.dimension; ++i) {
                    ptDst.setOrdinate(i, ptSrc.getOrdinate(i));
                }
                return ptDst;
            }
        }
        try {
            return super.transform(ptSrc, ptDst);
        }
        catch (TransformException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
    }

    public MathTransform inverse() {
        return this;
    }

    public int hashCode() {
        return 1861010892 + this.dimension;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IdentityTransform that = (IdentityTransform)object;
            return this.dimension == that.dimension;
        }
        return false;
    }
}

