/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.utilities;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Component;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.widget.ScrollingImagePanel;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageIOUtilities {
    private static final int DEFAULT_ROI = -999;

    public static ColorModel getCompatibleColorModel(SampleModel sm) {
        int nBands = sm.getNumBands();
        int bufferType = sm.getDataType();
        ColorModel cm = null;
        ColorSpace cs = null;
        if (nBands > 1) {
            cm = ImageUtil.createColorModel((SampleModel)sm);
        } else if (bufferType == 0 || bufferType == 1 || bufferType == 3 || bufferType == 4 || bufferType == 5) {
            cs = ColorSpace.getInstance(1003);
            cm = RasterFactory.createComponentColorModel((int)bufferType, (ColorSpace)cs, (boolean)false, (boolean)false, (int)1);
        } else if (bufferType == 2) {
            cs = ColorSpace.getInstance(1003);
            cm = new ComponentColorModel(cs, false, false, 1, 2);
        }
        return cm;
    }

    private ImageIOUtilities() {
    }

    public static void displayImageIOMetadata(Node root) {
        ImageIOUtilities.displayMetadata(root, 0);
    }

    static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    static void displayMetadata(Node node, int level) {
        Node child;
        ImageIOUtilities.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                String attrValue = attr.getNodeValue();
                if (attrValue == null) {
                    attrValue = "";
                }
                System.out.print(" " + attr.getNodeName() + "=\"" + attrValue + "\"");
            }
        }
        System.out.print(">");
        String nodeValue = node.getNodeValue();
        if (nodeValue != null) {
            System.out.println(" " + nodeValue);
        } else {
            System.out.println("");
        }
        if (child != null) {
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                ImageIOUtilities.displayMetadata(child, level + 1);
            }
            ImageIOUtilities.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        }
    }

    private static void visualizeRescaled(RenderedImage image, String title, int roiThreshold) {
        ROI roi = new ROI(image, roiThreshold);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        if (roi != null) {
            pb.add(roi);
        }
        RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb);
        double[][] extrema = (double[][])op.getProperty("extrema");
        double[] scale = new double[]{255.0 / (extrema[1][0] - extrema[0][0])};
        double[] offset = new double[]{255.0 * extrema[0][0] / (extrema[0][0] - extrema[1][0])};
        ParameterBlock pbRescale = new ParameterBlock();
        pbRescale.add(scale);
        pbRescale.add(offset);
        pbRescale.addSource(image);
        RenderedOp rescaledImage = JAI.create((String)"Rescale", (ParameterBlock)pbRescale);
        ParameterBlock pbConvert = new ParameterBlock();
        pbConvert.addSource(rescaledImage);
        pbConvert.add(0);
        RenderedOp destImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
        ImageIOUtilities.visualize((RenderedImage)destImage, title);
    }

    public static void visualize(RenderedImage ri) {
        ImageIOUtilities.visualize(ri, "");
    }

    public static void visualize(RenderedImage ri, String title) {
        final JFrame frame = new JFrame(title);
        frame.getContentPane().add((Component)new ScrollingImagePanel(ri, 1024, 768));
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                frame.pack();
                frame.setSize(1024, 768);
                frame.setVisible(true);
            }
        });
    }

    public static void visualize(RenderedImage ri, String title, boolean rescale) {
        ImageIOUtilities.visualize(ri, title, rescale, -999);
    }

    public static void visualize(RenderedImage ri, String title, boolean rescale, int roiThreshold) {
        if (rescale) {
            ImageIOUtilities.visualizeRescaled(ri, title, roiThreshold);
        } else {
            ImageIOUtilities.visualize(ri, title);
        }
    }
}

