/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.ve;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;

public class VEConverter
extends Service {
    public static final String SERVICE_VE = "ve";
    private static Log log = LogFactory.getLog(VEConverter.class);
    private StorageBroker sb;
    private TileLayerDispatcher tld;

    public VEConverter(StorageBroker sb, TileLayerDispatcher tld) {
        super(SERVICE_VE);
        this.sb = sb;
        this.tld = tld;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        Map params = request.getParameterMap();
        String layerId = super.getLayersParameter(request);
        String strQuadKey = ServletUtils.stringFromMap(params, "quadkey");
        String strFormat = ServletUtils.stringFromMap(params, "format");
        String strCached = ServletUtils.stringFromMap(params, "cached");
        String strMetaTiled = ServletUtils.stringFromMap(params, "metatiled");
        int[] gridLoc = VEConverter.convert(strQuadKey);
        MimeType mimeType = null;
        if (strFormat != null) {
            try {
                mimeType = MimeType.createFromFormat(strFormat);
            }
            catch (MimeException me) {
                throw new ServiceException("Unable to determined requested format, " + strFormat);
            }
        }
        ConveyorTile ret = new ConveyorTile(this.sb, layerId, SRS.getEPSG900913(), gridLoc, mimeType, null, null, request, response);
        if (strCached != null && !Boolean.parseBoolean(strCached)) {
            ret.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            if (strMetaTiled != null && !Boolean.parseBoolean(strMetaTiled)) {
                ret.setHint("not_cached,not_metatiled");
            } else {
                ret.setHint("not_cached");
            }
        }
        return ret;
    }

    public void handleRequest(ConveyorTile tile) throws GeoWebCacheException {
        if (tile.getHint() != null) {
            boolean requestTiled = true;
            if (tile.getHint().equals("not_cached,not_metatiled")) {
                requestTiled = false;
            } else if (!tile.getHint().equals("not_cached")) {
                throw new GeoWebCacheException("Hint " + tile.getHint() + " is not known.");
            }
            TileLayer tl = this.tld.getTileLayer(tile.getLayerId());
            if (tl == null) {
                throw new GeoWebCacheException("Unknown layer " + tile.getLayerId());
            }
            if (!tl.isCacheBypassAllowed().booleanValue()) {
                throw new GeoWebCacheException("Layer " + tile.getLayerId() + " is not configured to allow bypassing the cache.");
            }
            tile.setTileLayer(tl);
            tl.getNoncachedTile(tile, requestTiled);
            Service.writeTileResponse(tile, false);
        }
    }

    public static int[] convert(String strQuadKey) {
        char[] quadArray = strQuadKey.toCharArray();
        int zoomLevel = quadArray.length;
        int extent = (int)Math.pow(2.0, zoomLevel);
        int yPos = 0;
        int xPos = 0;
        for (int i = 0; i < zoomLevel; ++i) {
            char curChar = quadArray[i];
            extent /= 2;
            if (curChar == '0') {
                yPos += extent;
                continue;
            }
            if (curChar == '1') {
                xPos += extent;
                yPos += extent;
                continue;
            }
            if (curChar == '2') continue;
            if (curChar == '3') {
                xPos += extent;
                continue;
            }
            log.error((Object)("Don't know how to interpret quadKey: " + strQuadKey));
            return null;
        }
        int[] gridLoc = new int[]{xPos, yPos, zoomLevel};
        return gridLoc;
    }
}

