/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.kml;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.wms.BBOX;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLDebugGridLayer
extends TileLayer {
    public static final String LAYERNAME = "debugGrid";
    public static final int IS_KMZ = 100;
    private static KMLDebugGridLayer instance;

    private KMLDebugGridLayer() {
        this.grids = new Hashtable();
        this.grids.put(SRS.getEPSG4326(), new Grid(SRS.getEPSG4326(), BBOX.WORLD4326, BBOX.WORLD4326, null));
    }

    public static synchronized KMLDebugGridLayer getInstance() {
        if (instance == null) {
            instance = new KMLDebugGridLayer();
        }
        return instance;
    }

    @Override
    public void acquireLayerLock() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        return null;
    }

    public BBOX getBounds(SRS srs) {
        return new BBOX(-180.0, -90.0, 180.0, 90.0);
    }

    @Override
    public MimeType getDefaultMimeType() {
        return null;
    }

    @Override
    public int[] getMetaTilingFactors() {
        return null;
    }

    @Override
    public List<MimeType> getMimeTypes() {
        return null;
    }

    @Override
    public String getName() {
        return "Debug grid";
    }

    public SRS[] getProjections() {
        SRS[] srsList = new SRS[]{SRS.getEPSG4326()};
        return srsList;
    }

    public double[] getResolutions(int srsIdx) {
        return null;
    }

    @Override
    public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException {
        int[] gridLoc = tile.getTileIndex();
        BBOX bbox = this.getBboxForGridLoc(SRS.getEPSG4326(), gridLoc);
        String data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.1\">\n<Document>\n<Placemark id=\"PlaceMarkId\">\n<name>" + gridLoc[0] + "," + gridLoc[1] + "," + gridLoc[2] + "</name>" + "<Style id=\"square\">\n" + "<PolyStyle><color>7fffffff</color><colorMode>random</colorMode>\n" + "</PolyStyle>\n" + "<IconStyle><Icon><href>http://icons.opengeo.org/dynamic/circle/aaffaa_aaffaa_2.png</href></Icon></IconStyle>\n" + "<LabelStyle id=\"name\"><color>ffffffff</color><colorMode>normal</colorMode><scale>1.0</scale></LabelStyle>\n" + "</Style>\n" + "<MultiGeometry>\n" + "<Point><coordinates>" + (bbox.coords[0] + bbox.coords[2]) / 2.0 + "," + (bbox.coords[1] + bbox.coords[3]) / 2.0 + ",0</coordinates></Point>\n" + "<Polygon><outerBoundaryIs><LinearRing>\n" + "<coordinates decimal=\".\" cs=\",\" ts=\" \">\n" + bbox.coords[0] + "," + bbox.coords[1] + " " + bbox.coords[2] + "," + bbox.coords[1] + " " + bbox.coords[2] + "," + bbox.coords[3] + " " + bbox.coords[0] + "," + bbox.coords[3] + "</coordinates>\n" + "</LinearRing></outerBoundaryIs></Polygon>\n" + "</MultiGeometry>\n" + "</Placemark>\n" + "</Document>\n" + "</kml>";
        tile.setContent(data.getBytes());
        tile.setStatus(200);
        return tile;
    }

    @Override
    public String getStyles() {
        return null;
    }

    @Override
    public int[][] getZoomInGridLoc(SRS srs, int[] gridLoc) {
        int[][] retVal = new int[4][3];
        int x = gridLoc[0] * 2;
        int y = gridLoc[1] * 2;
        int z = gridLoc[2] + 1;
        if (z > 25) {
            z = -1;
        }
        int n = x;
        retVal[2][0] = n;
        retVal[0][0] = n;
        int n2 = x + 1;
        retVal[3][0] = n2;
        retVal[1][0] = n2;
        int n3 = y;
        retVal[1][1] = n3;
        retVal[0][1] = n3;
        int n4 = y + 1;
        retVal[3][1] = n4;
        retVal[2][1] = n4;
        int n5 = z;
        retVal[3][2] = n5;
        retVal[2][2] = n5;
        retVal[1][2] = n5;
        retVal[0][2] = n5;
        return retVal;
    }

    public int getZoomStart() {
        return 0;
    }

    public int getZoomStop() {
        return 25;
    }

    @Override
    public Boolean initialize() {
        return true;
    }

    @Override
    public Boolean isInitialized() {
        return true;
    }

    @Override
    public void releaseLayerLock() {
    }

    @Override
    public void setExpirationHeader(HttpServletResponse response) {
    }

    @Override
    public String supportsBbox(SRS srs, BBOX bounds) throws GeoWebCacheException {
        return null;
    }

    @Override
    public boolean supportsFormat(String formatStr) throws GeoWebCacheException {
        return false;
    }

    @Override
    public boolean supportsSRS(SRS srs) throws GeoWebCacheException {
        return false;
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
    }

    public int getType() {
        return 0;
    }

    public void init() {
    }

    @Override
    public BBOX getBboxForGridLoc(SRS srs, int[] gridLoc) {
        double tileWidth = 180.0 / Math.pow(2.0, gridLoc[2]);
        BBOX bbox = new BBOX(-180.0 + tileWidth * (double)gridLoc[0], -90.0 + tileWidth * (double)gridLoc[1], -180.0 + tileWidth * (double)(gridLoc[0] + 1), -90.0 + tileWidth * (double)(gridLoc[1] + 1));
        return bbox;
    }

    @Override
    public int[][] getCoveredGridLevels(SRS srs, BBOX bounds) {
        return null;
    }

    @Override
    public int[] getGridLocForBounds(SRS srs, BBOX bounds) throws BadTileException {
        return null;
    }

    @Override
    public int[] getZoomedOutGridLoc(SRS srs) {
        int[] zoomedOutGridLoc = new int[]{-1, -1, -1};
        return zoomedOutGridLoc;
    }

    @Override
    public ConveyorTile getNoncachedTile(ConveyorTile tile, boolean requestTiled) throws GeoWebCacheException {
        return null;
    }

    @Override
    public Boolean isCacheBypassAllowed() {
        return false;
    }

    @Override
    public void isCacheBypassAllowed(boolean allowed) {
    }

    @Override
    public Integer getBackendTimeout() {
        return null;
    }

    @Override
    public void setBackendTimeout(int seconds) {
    }

    @Override
    public void putTile(ConveyorTile tile) throws GeoWebCacheException {
    }

    @Override
    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
    }
}

