/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.util.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileLayerDispatcher {
    private static Log log = LogFactory.getLog(TileLayerDispatcher.class);
    private volatile HashMap<String, TileLayer> layers = null;
    private List<Configuration> configs = null;

    public TileLayer getTileLayer(String layerIdent) throws GeoWebCacheException {
        HashMap<String, TileLayer> tmpLayers = this.getLayers();
        TileLayer layer = tmpLayers.get(layerIdent);
        if (layer == null) {
            throw new GeoWebCacheException("Unknown layer " + layerIdent + ". Check the logfiles," + " it may not have loaded properly.");
        }
        layer.isInitialized();
        return layer;
    }

    public void setConfig(List<Configuration> configs) {
        this.configs = configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInit() throws GeoWebCacheException {
        TileLayerDispatcher tileLayerDispatcher = this;
        synchronized (tileLayerDispatcher) {
            this.layers = null;
        }
        this.getLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, TileLayer> getLayers() {
        HashMap<String, TileLayer> result = this.layers;
        if (result == null) {
            TileLayerDispatcher tileLayerDispatcher = this;
            synchronized (tileLayerDispatcher) {
                result = this.layers;
                if (result == null) {
                    this.layers = result = this.initialize();
                }
            }
        }
        return result;
    }

    private HashMap<String, TileLayer> initialize() {
        log.debug((Object)"Thread initLayers(), initializing");
        this.layers = new HashMap();
        Iterator<Configuration> configIter = this.configs.iterator();
        while (configIter.hasNext()) {
            List<TileLayer> configLayers = null;
            Configuration config = configIter.next();
            String configIdent = null;
            try {
                configIdent = config.getIdentifier();
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
            }
            if (configIdent == null) continue;
            try {
                configLayers = config.getTileLayers(true);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
                log.error((Object)("Failed to add layers from " + configIdent));
            }
            log.info((Object)("Adding layers from " + configIdent));
            if (configLayers != null && configLayers.size() > 0) {
                for (TileLayer layer : configLayers) {
                    this.add(layer);
                }
                continue;
            }
            log.error((Object)("Configuration " + configIdent + " contained no layers."));
        }
        return this.layers;
    }

    public void update(TileLayer layer) {
        TileLayer oldLayer = this.layers.get(layer.getName());
        oldLayer.acquireLayerLock();
        this.layers.remove(layer.getName());
        oldLayer.releaseLayerLock();
        this.layers.put(layer.getName(), layer);
    }

    public void remove(String layerName) {
        TileLayer layer = this.layers.get(layerName);
        layer.acquireLayerLock();
        this.layers.remove(layerName);
        layer.releaseLayerLock();
    }

    public void add(TileLayer layer) {
        if (this.layers.containsKey(layer.getName())) {
            try {
                this.layers.get(layer.getName()).mergeWith(layer);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
            }
        } else {
            this.layers.put(layer.getName(), layer);
        }
    }
}

