/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.wms.BBOX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TileLayer {
    private static Log log = LogFactory.getLog(TileLayer.class);
    protected String name;
    protected List<String> mimeFormats;
    protected Hashtable<SRS, Grid> grids;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addGrid(SRS srs, Grid grid) {
        this.grids.put(srs, grid);
    }

    public Hashtable<SRS, Grid> getGrids() {
        return this.grids;
    }

    public void addFormat(String format) {
        this.mimeFormats.add(format);
    }

    public abstract Boolean isInitialized();

    protected abstract Boolean initialize();

    public boolean supportsSRS(SRS srs) throws GeoWebCacheException {
        return this.isInitialized() != false && this.grids.containsKey(srs);
    }

    public boolean supportsFormat(String strFormat) throws GeoWebCacheException {
        if (strFormat == null) {
            return true;
        }
        for (String format : this.mimeFormats) {
            if (!strFormat.equalsIgnoreCase(format)) continue;
            return true;
        }
        throw new GeoWebCacheException("Format " + strFormat + " is not supported by " + this.getName());
    }

    public String supportsBbox(SRS srs, BBOX reqBounds) throws GeoWebCacheException {
        this.supportsSRS(srs);
        if (!reqBounds.isSane()) {
            return "The requested bounding box " + reqBounds.getReadableString() + " is not sane";
        }
        if (!this.grids.get((Object)srs).dataBounds.contains(reqBounds)) {
            return "The layers grid box " + this.grids.get((Object)srs).dataBounds.getReadableString() + " does not cover the requested bounding box " + reqBounds.getReadableString();
        }
        return null;
    }

    public abstract ConveyorTile getTile(ConveyorTile var1) throws GeoWebCacheException, IOException;

    public abstract ConveyorTile getNoncachedTile(ConveyorTile var1, boolean var2) throws GeoWebCacheException;

    public abstract void seedTile(ConveyorTile var1, boolean var2) throws GeoWebCacheException, IOException;

    public abstract ConveyorTile doNonMetatilingRequest(ConveyorTile var1) throws GeoWebCacheException;

    public Grid getGrid(SRS srs) {
        return this.grids.get(srs);
    }

    public double[] getResolutions(SRS srs) throws GeoWebCacheException {
        return this.grids.get(srs).getGridCalculator().getResolutions();
    }

    public abstract String getStyles();

    public abstract int[] getMetaTilingFactors();

    public abstract Boolean isCacheBypassAllowed();

    public abstract void isCacheBypassAllowed(boolean var1);

    public abstract Integer getBackendTimeout();

    public abstract void setBackendTimeout(int var1);

    public abstract int[][] getCoveredGridLevels(SRS var1, BBOX var2) throws GeoWebCacheException;

    public abstract List<MimeType> getMimeTypes();

    public abstract MimeType getDefaultMimeType();

    public abstract void destroy();

    public abstract int[] getGridLocForBounds(SRS var1, BBOX var2) throws BadTileException, GeoWebCacheException;

    public abstract BBOX getBboxForGridLoc(SRS var1, int[] var2) throws GeoWebCacheException;

    public int getZoomStart(SRS srs) {
        return this.grids.get(srs).getZoomStart();
    }

    public int getZoomStop(SRS srs) {
        return this.grids.get(srs).getZoomStop();
    }

    public abstract int[][] getZoomInGridLoc(SRS var1, int[] var2) throws GeoWebCacheException;

    public abstract int[] getZoomedOutGridLoc(SRS var1) throws GeoWebCacheException;

    public abstract void acquireLayerLock();

    public abstract void releaseLayerLock();

    public abstract void putTile(ConveyorTile var1) throws GeoWebCacheException;

    public abstract void setExpirationHeader(HttpServletResponse var1);

    public void mergeWith(TileLayer otherLayer) throws GeoWebCacheException {
        log.warn((Object)("Merging grids, formats and filters of " + this.name));
        if (otherLayer.mimeFormats != null) {
            for (String string : otherLayer.mimeFormats) {
                if (this.supportsFormat(string)) continue;
                this.addFormat(string);
            }
        }
        if (otherLayer.grids != null && otherLayer.grids.size() > 0) {
            for (Map.Entry entry : otherLayer.grids.entrySet()) {
                this.grids.put((SRS)entry.getKey(), (Grid)entry.getValue());
            }
        }
        if (this instanceof WMSLayer) {
            WMSLayer thisWMSLayer = (WMSLayer)this;
            thisWMSLayer.mergeWith((WMSLayer)otherLayer);
        }
    }
}

