/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.AbstractReferenceSystem;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    protected final CoordinateSystem coordinateSystem;

    public AbstractCRS(CoordinateReferenceSystem crs) {
        super((ReferenceSystem)crs);
        this.coordinateSystem = crs.getCoordinateSystem();
    }

    public AbstractCRS(Map<String, ?> properties, CoordinateSystem cs) {
        super(properties);
        AbstractCRS.ensureNonNull("cs", cs);
        this.coordinateSystem = cs;
    }

    static Map<String, ?> name(int key) {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        InternationalString name = Vocabulary.formatInternational((int)key);
        properties.put("name", name.toString());
        properties.put("alias", (String)name);
        return properties;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final Unit<?> getUnit() {
        return CRSUtilities.getUnit(this.coordinateSystem);
    }

    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (this.coordinateSystem instanceof AbstractCS) {
            return ((AbstractCS)this.coordinateSystem).distance(coord1, coord2);
        }
        throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractCRS that = (AbstractCRS)object;
            return AbstractCRS.equals((IdentifiedObject)this.coordinateSystem, (IdentifiedObject)that.coordinateSystem, compareMetadata);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x3D90441 ^ this.coordinateSystem.hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        this.formatDefaultWKT(formatter);
        return super.formatWKT(formatter);
    }

    void formatDefaultWKT(Formatter formatter) {
        Unit<?> unit = this.getUnit();
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append((IdentifiedObject)this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(CoordinateReferenceSystem.class);
        }
    }
}

