/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemorySpatialIndex {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.imagemosaic");
    private final STRtree index;

    public MemorySpatialIndex(FeatureCollection<SimpleFeatureType, SimpleFeature> features) {
        if (features == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The provided FeatureCollection<SimpleFeatureType, SimpleFeature> is null, it's impossible to create an index!");
            }
            throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature> is null, it's impossible to create an index!");
        }
        FeatureIterator<SimpleFeature> it = features.features();
        if (!it.hasNext()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
            }
            throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
        }
        this.index = new STRtree();
        while (it.hasNext()) {
            SimpleFeature f = it.next();
            Geometry g = (Geometry)f.getDefaultGeometry();
            this.index.insert(g.getEnvelopeInternal(), (Object)f);
        }
        features.close(it);
        this.index.build();
    }

    public List<SimpleFeature> findFeatures(Envelope envelope) {
        return this.index.query(envelope);
    }
}

