/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.ResultTypeType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.common.util.EList;
import org.geotools.data.wfs.protocol.wfs.GetFeature;
import org.geotools.data.wfs.protocol.wfs.WFSOperationType;
import org.geotools.data.wfs.protocol.wfs.WFSProtocol;
import org.geotools.data.wfs.v1_1_0.WFSStrategy;
import org.geotools.factory.GeoTools;
import org.geotools.filter.Capabilities;
import org.geotools.filter.v1_1.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.filter.visitor.CapabilitiesFilterSplitter;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.sort.SortBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWFSStrategy
implements WFSStrategy {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    protected static final String DEFAULT_OUTPUT_FORMAT = "text/xml; subtype=gml/3.1.1";
    private static final Configuration filter_1_1_0_Configuration = new OGCConfiguration();
    private static final Configuration wfs_1_1_0_Configuration = new WFSConfiguration();

    @Override
    public boolean supportsGet() {
        return true;
    }

    @Override
    public boolean supportsPost() {
        return true;
    }

    @Override
    public String getDefaultOutputFormat(WFSProtocol wfs, WFSOperationType operation) {
        if (WFSOperationType.GET_FEATURE != operation) {
            throw new UnsupportedOperationException("Not implemented for other than GET_FEATURE yet");
        }
        Set<String> supportedOutputFormats = wfs.getSupportedGetFeatureOutputFormats();
        if (supportedOutputFormats.contains(DEFAULT_OUTPUT_FORMAT)) {
            return DEFAULT_OUTPUT_FORMAT;
        }
        throw new IllegalArgumentException("Server does not support 'text/xml; subtype=gml/3.1.1' output format: " + supportedOutputFormats);
    }

    @Override
    public WFSStrategy.RequestComponents createGetFeatureRequest(WFSProtocol wfs, GetFeature query) throws IOException {
        SortBy[] sortByList;
        boolean retrieveAllProperties;
        GetFeature.ResultType resultType;
        WfsFactory factory = WfsFactory.eINSTANCE;
        GetFeatureType getFeature = factory.createGetFeatureType();
        getFeature.setService("WFS");
        getFeature.setVersion(wfs.getServiceVersion().toString());
        getFeature.setOutputFormat(query.getOutputFormat());
        getFeature.setHandle("GeoTools " + GeoTools.getVersion() + " WFS DataStore");
        Integer maxFeatures = query.getMaxFeatures();
        if (maxFeatures != null) {
            getFeature.setMaxFeatures(BigInteger.valueOf(maxFeatures.intValue()));
        }
        getFeature.setResultType(GetFeature.ResultType.RESULTS == (resultType = query.getResultType()) ? ResultTypeType.RESULTS_LITERAL : ResultTypeType.HITS_LITERAL);
        QueryType wfsQuery = factory.createQueryType();
        wfsQuery.setTypeName(Collections.singletonList(query.getTypeName()));
        Filter serverFilter = query.getFilter();
        if (!Filter.INCLUDE.equals(serverFilter)) {
            wfsQuery.setFilter(serverFilter);
        }
        String srsName = query.getSrsName();
        try {
            wfsQuery.setSrsName(new URI(srsName));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can't create a URI from the query CRS: " + srsName, e);
        }
        String[] propertyNames = query.getPropertyNames();
        boolean bl = retrieveAllProperties = propertyNames == null;
        if (!retrieveAllProperties) {
            EList propertyName = wfsQuery.getPropertyName();
            for (String string : propertyNames) {
                propertyName.add(string);
            }
        }
        if ((sortByList = query.getSortBy()) != null) {
            for (String string : sortByList) {
                wfsQuery.getSortBy().add((Object)string);
            }
        }
        getFeature.getQuery().add((Object)wfsQuery);
        WFSStrategy.RequestComponents reqParts = new WFSStrategy.RequestComponents();
        reqParts.setServerRequest(getFeature);
        Map<String, String> parametersForGet = this.buildGetFeatureParametersForGet(getFeature);
        reqParts.setKvpParameters(parametersForGet);
        return reqParts;
    }

    protected Map<String, String> buildGetFeatureParametersForGet(GetFeatureType request) throws IOException {
        Filter filter;
        URI srsName;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SERVICE", "WFS");
        map.put("VERSION", "1.1.0");
        map.put("REQUEST", "GetFeature");
        map.put("OUTPUTFORMAT", request.getOutputFormat());
        if (request.getMaxFeatures() != null) {
            map.put("MAXFEATURES", String.valueOf(request.getMaxFeatures()));
        }
        QueryType query = (QueryType)request.getQuery().get(0);
        String typeName = (String)query.getTypeName().get(0);
        map.put("TYPENAME", typeName);
        if (query.getPropertyName().size() > 0) {
            EList propertyNames = query.getPropertyName();
            StringBuilder pnames = new StringBuilder();
            Iterator it = propertyNames.iterator();
            while (it.hasNext()) {
                pnames.append((String)it.next());
                if (!it.hasNext()) continue;
                pnames.append(',');
            }
            map.put("PROPERTYNAME", pnames.toString());
        }
        if ((srsName = query.getSrsName()) != null) {
            map.put("SRSNAME", srsName.toString());
        }
        if ((filter = query.getFilter()) != null && Filter.INCLUDE != filter) {
            if (filter instanceof Id) {
                Set identifiers = ((Id)filter).getIdentifiers();
                StringBuffer idValues = new StringBuffer();
                Iterator it = identifiers.iterator();
                while (it.hasNext()) {
                    Object id = ((Identifier)it.next()).getID();
                    idValues.append(String.valueOf(id));
                    if (!it.hasNext()) continue;
                    idValues.append(",");
                }
                map.put("FEATUREID", idValues.toString());
            } else {
                String xmlEncodedFilter = this.encodeGetFeatureGetFilter(filter);
                map.put("FILTER", xmlEncodedFilter);
            }
        }
        return map;
    }

    protected String encodeGetFeatureGetFilter(Filter filter) throws IOException {
        Configuration filterConfig = this.getFilterConfiguration();
        Encoder encoder = new Encoder(filterConfig);
        encoder.setOmitXMLDeclaration(true);
        encoder.setEncoding(Charset.forName("UTF-8"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        encoder.encode((Object)filter, OGC.Filter, (OutputStream)out);
        String encoded = ((Object)out).toString();
        encoded = encoded.replaceAll("\n", "");
        return encoded;
    }

    protected Configuration getFilterConfiguration() {
        return filter_1_1_0_Configuration;
    }

    @Override
    public Configuration getWfsConfiguration() {
        return wfs_1_1_0_Configuration;
    }

    @Override
    public Filter[] splitFilters(Capabilities caps, Filter queryFilter) {
        CapabilitiesFilterSplitter splitter = new CapabilitiesFilterSplitter(caps, null, null);
        queryFilter.accept((FilterVisitor)splitter, null);
        Filter server = splitter.getFilterPre();
        Filter post = splitter.getFilterPost();
        return new Filter[]{server, post};
    }
}

