/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.filter.capability;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.opengis.feature.type.Name;

public final class GeometryOperand
implements Name,
Serializable {
    private static final long serialVersionUID = -9006169053542932716L;
    private static final Map<GeometryOperand, GeometryOperand> POOL = new HashMap<GeometryOperand, GeometryOperand>();
    public static final GeometryOperand Envelope = new GeometryOperand("Envelope");
    public static final GeometryOperand Point = new GeometryOperand("Point");
    public static final GeometryOperand LineString = new GeometryOperand("LineString");
    public static final GeometryOperand Polygon = new GeometryOperand("Polygon");
    public static final GeometryOperand ArcByCenterPoint = new GeometryOperand("ArcByCenterPoint");
    public static final GeometryOperand CircleByCenterPoint = new GeometryOperand("CircleByCenterPoint");
    public static final GeometryOperand Arc = new GeometryOperand("Arc");
    public static final GeometryOperand Circle = new GeometryOperand("Circle");
    public static final GeometryOperand ArcByBulge = new GeometryOperand("ArcByBulge");
    public static final GeometryOperand Bezier = new GeometryOperand("Bezier");
    public static final GeometryOperand Clothoid = new GeometryOperand("Clothoid");
    public static final GeometryOperand CubicSpline = new GeometryOperand("CubicSpline");
    public static final GeometryOperand Geodesic = new GeometryOperand("Geodesic");
    public static final GeometryOperand OffsetCurve = new GeometryOperand("OffsetCurve");
    public static final GeometryOperand Triangle = new GeometryOperand("Triangle");
    public static final GeometryOperand PolyhedralSurface = new GeometryOperand("PolyhedralSurface");
    public static final GeometryOperand TriangulatedSurface = new GeometryOperand("TriangulatedSurface");
    public static final GeometryOperand Tin = new GeometryOperand("Tin");
    public static final GeometryOperand Solid = new GeometryOperand("Solid");
    private final String namespaceURI;
    private final String name;

    private GeometryOperand(String string) {
        this("http://www.opengis.net/gml", string);
    }

    private GeometryOperand(String string, String string2) {
        this.namespaceURI = string;
        this.name = string2;
        POOL.put(this, this);
    }

    public static GeometryOperand get(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            string = "http://www.opengis.net/gml";
        }
        string2 = string2.trim();
        return POOL.get(new GeometryOperand(string, string2));
    }

    public String getLocalPart() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getURI() {
        return this.namespaceURI + '/' + this.name;
    }

    public boolean isGlobal() {
        return false;
    }

    public int hashCode() {
        return this.namespaceURI.hashCode() + 37 * this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof GeometryOperand) {
            GeometryOperand geometryOperand = (GeometryOperand)object;
            return this.namespaceURI.equals(geometryOperand.namespaceURI) && this.name.equals(geometryOperand.name);
        }
        return false;
    }

    public String toString() {
        return this.getURI();
    }

    private Object readResolve() throws ObjectStreamException {
        GeometryOperand geometryOperand = POOL.get(this);
        return geometryOperand != null ? geometryOperand : this;
    }
}

