/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.dto.TestSuiteDTO;
import org.vfny.geoserver.config.validation.PlugInConfig;
import org.vfny.geoserver.config.validation.TestConfig;
import org.vfny.geoserver.config.validation.TestSuiteConfig;
import org.vfny.geoserver.global.GeoValidator;

public class ValidationConfig {
    public static final String CONFIG_KEY = "Validation.Config";
    private Map plugIns = new HashMap();
    private Map testSuites = new HashMap();

    public ValidationConfig() {
    }

    public ValidationConfig(GeoValidator validator) {
        this(validator.getPlugIns(), validator.getTestSuites());
    }

    public ValidationConfig(Map plugIns, Map testSuites) {
        Object config;
        PlugInDTO dto;
        Iterator i = null;
        i = plugIns.keySet().iterator();
        while (i.hasNext()) {
            dto = (PlugInDTO)plugIns.get(i.next());
            config = new PlugInConfig(dto);
            this.plugIns.put(((PlugInConfig)config).getName(), config);
        }
        i = testSuites.keySet().iterator();
        while (i.hasNext()) {
            dto = (TestSuiteDTO)testSuites.get(i.next());
            config = new TestSuiteConfig((TestSuiteDTO)dto, this.plugIns);
            this.testSuites.put(((TestSuiteConfig)config).getName(), config);
        }
    }

    public PlugInConfig getPlugIn(String name) {
        if (name == null) {
            return null;
        }
        return (PlugInConfig)this.plugIns.get(name);
    }

    public TestSuiteConfig getTestSuite(String name) {
        if (name == null) {
            return null;
        }
        return (TestSuiteConfig)this.testSuites.get(name);
    }

    public TestConfig getTest(String name, String testSuite) {
        if (name == null || testSuite == null) {
            return null;
        }
        TestSuiteConfig tcn = this.getTestSuite(testSuite);
        if (tcn == null) {
            return null;
        }
        return (TestConfig)tcn.getTests().get(name);
    }

    public boolean addPlugIn(PlugInConfig plugIn) {
        this.plugIns.put(plugIn.getName(), plugIn);
        return true;
    }

    public boolean addTest(TestConfig test, String testSuite) {
        TestSuiteConfig tsc = (TestSuiteConfig)this.testSuites.get(testSuite);
        if (tsc != null && this.plugIns.containsKey(test.getPlugIn().getName())) {
            tsc.getTests().put(test.getName(), test);
            return true;
        }
        return false;
    }

    public boolean addTestSuite(TestSuiteConfig testSuite) {
        Iterator i = testSuite.getTests().keySet().iterator();
        while (i.hasNext()) {
            TestConfig test = (TestConfig)testSuite.getTests().get(i.next());
            if (this.plugIns.containsKey(test.getPlugIn().getName())) continue;
            return false;
        }
        this.testSuites.put(testSuite.getName(), testSuite);
        return true;
    }

    public Object removeTestSuite(String name) {
        return this.testSuites.remove(name);
    }

    public Object removePlugIn(String name) {
        return this.plugIns.remove(name);
    }

    public Object removeTest(String testSuite, String name) {
        return ((TestSuiteConfig)this.testSuites.get(testSuite)).getTests().remove(name);
    }

    public boolean toDTO(Map plugIns, Map testSuites) {
        PlugInDTO dto;
        if (plugIns == null || testSuites == null) {
            return false;
        }
        if (plugIns.size() != 0 || testSuites.size() != 0) {
            return false;
        }
        Iterator i = null;
        i = this.plugIns.keySet().iterator();
        while (i.hasNext()) {
            dto = ((PlugInConfig)this.plugIns.get(i.next())).toDTO();
            plugIns.put(dto.getName(), dto);
        }
        i = this.testSuites.keySet().iterator();
        while (i.hasNext()) {
            dto = ((TestSuiteConfig)this.testSuites.get(i.next())).toDTO(plugIns);
            testSuites.put(dto.getName(), dto);
        }
        return true;
    }

    public Map getPlugIns() {
        return this.plugIns;
    }

    public Set getPlugInNames() {
        return this.plugIns.keySet();
    }

    public void setPlugIns(Map plugIns) {
        this.plugIns = plugIns;
    }

    public Map getTestSuites() {
        return this.testSuites;
    }

    public Set getTestSuiteNames() {
        return this.testSuites.keySet();
    }

    public void setTestSuites(Map testSuites) {
        this.testSuites = testSuites;
    }
}

