/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.validation.dto.TestDTO;
import org.geotools.validation.dto.TestSuiteDTO;
import org.vfny.geoserver.config.validation.TestConfig;

public class TestSuiteConfig {
    public static final String CONFIG_KEY = "Validation.TestSuite";
    public static final String CURRENTLY_SELECTED_KEY = "selectedTestSuite";
    private String name;
    private String description;
    private Map tests;

    public TestSuiteConfig() {
        this.tests = new HashMap();
    }

    public TestSuiteConfig(TestSuiteConfig ts) {
        this.name = ts.getName();
        this.description = ts.getDescription();
        this.tests = new HashMap();
        Iterator i = ts.getTests().keySet().iterator();
        while (i.hasNext()) {
            TestConfig t = (TestConfig)ts.getTests().get(i.next());
            this.tests.put(t.getName(), new TestConfig(t));
        }
    }

    public TestSuiteConfig(TestSuiteDTO ts, Map plugInConfigs) {
        this.name = ts.getName();
        this.description = ts.getDescription();
        this.tests = new HashMap();
        Iterator i = ts.getTests().keySet().iterator();
        while (i.hasNext()) {
            TestDTO t = (TestDTO)ts.getTests().get(i.next());
            this.tests.put(t.getName(), new TestConfig(t, plugInConfigs));
        }
    }

    public Object clone() {
        return new TestSuiteConfig(this);
    }

    public int hashCode() {
        int r = 1;
        if (this.tests != null) {
            r *= ((Object)this.tests).hashCode();
        }
        if (this.name != null) {
            r *= this.name.hashCode();
        }
        if (this.description != null) {
            r *= this.description.hashCode();
        }
        return r;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TestSuiteDTO)) {
            return false;
        }
        boolean r = true;
        TestSuiteDTO ts = (TestSuiteDTO)obj;
        if (this.name != null) {
            boolean bl = r = r && this.name.equals(ts.getName());
        }
        if (this.description != null) {
            boolean bl = r = r && this.description.equals(ts.getDescription());
        }
        if (this.tests == null) {
            if (ts.getTests() != null) {
                return false;
            }
        } else if (ts.getTests() != null) {
            r = r && ((Object)this.tests).equals(ts.getTests());
        } else {
            return false;
        }
        return r;
    }

    public TestSuiteDTO toDTO(Map plugIns) {
        TestSuiteDTO ts = new TestSuiteDTO();
        ts.setName(this.name);
        ts.setDescription(this.description);
        HashMap<String, TestDTO> myTests = new HashMap<String, TestDTO>();
        Iterator i = this.tests.keySet().iterator();
        while (i.hasNext()) {
            TestConfig t = (TestConfig)this.tests.get(i.next());
            myTests.put(t.getName(), t.toDTO(plugIns));
        }
        ts.setTests(myTests);
        return ts;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getTests() {
        return this.tests;
    }

    public Object removeTest(String name) {
        return this.tests.remove(name);
    }

    public void addTest(TestConfig test) {
        this.tests.put(test.getName(), test);
    }

    public void setTests(Map tests) {
        this.tests = tests;
    }
}

