/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.util.HeaderReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Parameter;
import org.restlet.util.DateUtils;

public class CookieReader
extends HeaderReader {
    private static final String NAME_VERSION = "$Version";
    private static final String NAME_PATH = "$Path";
    private static final String NAME_DOMAIN = "$Domain";
    private static final String NAME_SET_COMMENT = "comment";
    private static final String NAME_SET_COMMENT_URL = "commentURL";
    private static final String NAME_SET_DISCARD = "discard";
    private static final String NAME_SET_DOMAIN = "domain";
    private static final String NAME_SET_EXPIRES = "expires";
    private static final String NAME_SET_MAX_AGE = "max-age";
    private static final String NAME_SET_PATH = "path";
    private static final String NAME_SET_PORT = "port";
    private static final String NAME_SET_SECURE = "secure";
    private static final String NAME_SET_VERSION = "version";
    private Logger logger;
    private Parameter cachedPair;
    private int globalVersion;

    public CookieReader(Logger logger, String header) {
        super(header);
        this.logger = logger;
        this.cachedPair = null;
        this.globalVersion = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cookie readCookie() throws IOException {
        Cookie result = null;
        Parameter pair = this.readPair();
        if (this.globalVersion == -1) {
            if (pair.getName().equalsIgnoreCase(NAME_VERSION)) {
                if (pair.getValue() == null) throw new IOException("Empty cookies version attribute detected. Please check your cookie header");
                this.globalVersion = Integer.parseInt(pair.getValue());
            } else {
                this.globalVersion = 0;
            }
        }
        while (pair != null && pair.getName().charAt(0) == '$') {
            pair = this.readPair();
        }
        if (pair != null) {
            result = new Cookie(this.globalVersion, pair.getName(), pair.getValue());
            pair = this.readPair();
        }
        while (pair != null && pair.getName().charAt(0) == '$') {
            if (pair.getName().equalsIgnoreCase(NAME_PATH)) {
                result.setPath(pair.getValue());
            } else if (pair.getName().equalsIgnoreCase(NAME_DOMAIN)) {
                result.setDomain(pair.getValue());
            }
            pair = this.readPair();
        }
        if (pair == null) return result;
        this.cachedPair = pair;
        return result;
    }

    public CookieSetting readCookieSetting() throws IOException {
        CookieSetting result = null;
        Parameter pair = this.readPair();
        while (pair != null && pair.getName().charAt(0) == '$') {
            pair = this.readPair();
        }
        if (pair != null) {
            result = new CookieSetting(pair.getName(), pair.getValue());
            pair = this.readPair();
        }
        while (pair != null) {
            if (pair.getName().equalsIgnoreCase(NAME_SET_PATH)) {
                result.setPath(pair.getValue());
            } else if (pair.getName().equalsIgnoreCase(NAME_SET_DOMAIN)) {
                result.setDomain(pair.getValue());
            } else if (pair.getName().equalsIgnoreCase(NAME_SET_COMMENT)) {
                result.setComment(pair.getValue());
            } else if (!pair.getName().equalsIgnoreCase(NAME_SET_COMMENT_URL)) {
                if (pair.getName().equalsIgnoreCase(NAME_SET_DISCARD)) {
                    result.setMaxAge(-1);
                } else if (pair.getName().equalsIgnoreCase(NAME_SET_EXPIRES)) {
                    Date current = new Date(System.currentTimeMillis());
                    Date expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_RFC_1036);
                    if (expires == null) {
                        expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_RFC_1123);
                    }
                    if (expires == null) {
                        expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_ASC_TIME);
                    }
                    if (expires != null) {
                        if (DateUtils.after(current, expires)) {
                            result.setMaxAge((int)((expires.getTime() - current.getTime()) / 1000L));
                        } else {
                            result.setMaxAge(0);
                        }
                    } else {
                        this.logger.log(Level.WARNING, "Ignoring cookie setting expiration date. Unable to parse the date: " + pair.getValue());
                    }
                } else if (pair.getName().equalsIgnoreCase(NAME_SET_MAX_AGE)) {
                    result.setMaxAge(Integer.valueOf(pair.getValue()));
                } else if (!pair.getName().equalsIgnoreCase(NAME_SET_PORT)) {
                    if (pair.getName().equalsIgnoreCase(NAME_SET_SECURE)) {
                        if (pair.getValue() == null || pair.getValue().length() == 0) {
                            result.setSecure(true);
                        }
                    } else if (pair.getName().equalsIgnoreCase(NAME_SET_VERSION)) {
                        result.setVersion(Integer.valueOf(pair.getValue()));
                    }
                }
            }
            pair = this.readPair();
        }
        return result;
    }

    private Parameter readPair() throws IOException {
        Parameter result = null;
        if (this.cachedPair != null) {
            result = this.cachedPair;
            this.cachedPair = null;
        } else {
            try {
                boolean readingName = true;
                boolean readingValue = false;
                StringBuilder nameBuffer = new StringBuilder();
                StringBuilder valueBuffer = new StringBuilder();
                int nextChar = 0;
                while (result == null && nextChar != -1) {
                    nextChar = this.read();
                    if (readingName) {
                        if (HttpUtils.isSpace(nextChar) && nameBuffer.length() == 0) continue;
                        if (nextChar == -1 || nextChar == 59 || nextChar == 44) {
                            if (nameBuffer.length() > 0) {
                                result = HttpUtils.createParameter(nameBuffer, null);
                                continue;
                            }
                            if (nextChar == -1) continue;
                            throw new IOException("Empty cookie name detected. Please check your cookies");
                        }
                        if (nextChar == 61) {
                            readingName = false;
                            readingValue = true;
                            continue;
                        }
                        if (HttpUtils.isTokenChar(nextChar) || this.globalVersion < 1) {
                            nameBuffer.append((char)nextChar);
                            continue;
                        }
                        throw new IOException("Separator and control characters are not allowed within a token. Please check your cookie header");
                    }
                    if (!readingValue || HttpUtils.isSpace(nextChar) && valueBuffer.length() == 0) continue;
                    if (nextChar == -1 || nextChar == 59) {
                        result = HttpUtils.createParameter(nameBuffer, valueBuffer);
                        continue;
                    }
                    if (nextChar == 34 && valueBuffer.length() == 0) {
                        valueBuffer.append(this.readQuotedString());
                        continue;
                    }
                    if (HttpUtils.isTokenChar(nextChar) || this.globalVersion < 1) {
                        valueBuffer.append((char)nextChar);
                        continue;
                    }
                    throw new IOException("Separator and control characters are not allowed within a token. Please check your cookie header");
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new IOException("Unsupported encoding. Please contact the administrator");
            }
        }
        return result;
    }
}

