/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.HttpServerHelper;
import com.noelios.restlet.http.StreamServerCall;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.restlet.Server;
import org.restlet.data.Protocol;

public class StreamServerHelper
extends HttpServerHelper {
    private ServerSocket serverSocket;
    private SocketAddress socketAddress;
    private ExecutorService executorService;

    public StreamServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTP);
    }

    public ServerSocket createSocket() throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        return serverSocket;
    }

    public SocketAddress createSocketAddress() throws IOException {
        if (this.getServer().getAddress() == null) {
            return new InetSocketAddress(this.getServer().getPort());
        }
        return new InetSocketAddress(this.getServer().getAddress(), this.getServer().getPort());
    }

    public void start() throws Exception {
        super.start();
        this.getLogger().info("Starting the internal HTTP server");
        new Listener(this).start();
    }

    public void stop() throws Exception {
        super.stop();
        this.getLogger().info("Stopping the internal HTTP server");
        if (this.serverSocket.isBound()) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    class Listener
    extends Thread {
        private StreamServerHelper helper;

        Listener(StreamServerHelper helper) {
            this.helper = helper;
        }

        public void run() {
            try {
                if (StreamServerHelper.this.socketAddress == null) {
                    StreamServerHelper.this.socketAddress = StreamServerHelper.this.createSocketAddress();
                }
                StreamServerHelper.this.executorService = Executors.newFixedThreadPool(10);
                StreamServerHelper.this.serverSocket = StreamServerHelper.this.createSocket();
                if (StreamServerHelper.this.socketAddress != null) {
                    StreamServerHelper.this.serverSocket.bind(StreamServerHelper.this.socketAddress);
                }
                while (true) {
                    StreamServerHelper.this.executorService.execute(new Connection(this.helper, StreamServerHelper.this.serverSocket.accept()));
                }
            }
            catch (IOException ioe) {
                try {
                    this.helper.stop();
                }
                catch (Exception e) {
                    StreamServerHelper.this.getLogger().log(Level.WARNING, "Unexpected error while stopping the connector", e);
                }
                return;
            }
        }
    }

    class Connection
    implements Runnable {
        private StreamServerHelper helper;
        private final Socket socket;

        Connection(StreamServerHelper helper, Socket socket) {
            this.helper = helper;
            this.socket = socket;
        }

        public void run() {
            try {
                this.helper.handle(new StreamServerCall(this.helper.getServer(), this.socket.getInputStream(), this.socket.getOutputStream()));
                this.socket.getOutputStream().close();
                this.socket.close();
            }
            catch (IOException ioe) {
                StreamServerHelper.this.getLogger().log(Level.WARNING, "Unexpected error while handle a call", ioe);
            }
        }
    }
}

