/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.IOException;
import java.io.Writer;

public class ResponseUtils {
    public static String encodeXML(String inData) {
        if (inData == null) {
            return null;
        }
        if (inData.indexOf(38) == -1 && inData.indexOf(60) == -1 && inData.indexOf(62) == -1 && inData.indexOf(39) == -1 && inData.indexOf(34) == -1) {
            return inData;
        }
        int length = inData.length();
        StringBuffer buffer = new StringBuffer(2 * length);
        for (int i = 0; i < length; ++i) {
            char charToCompare = inData.charAt(i);
            if (charToCompare == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (charToCompare == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (charToCompare == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (charToCompare == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (charToCompare == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(charToCompare);
        }
        return buffer.toString();
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c == '>') {
                writer.write("&gt;");
                continue;
            }
            if (c == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c == '\'') {
                writer.write("&apos;");
                continue;
            }
            if (c == '\"') {
                writer.write("&quot;");
                continue;
            }
            writer.write(c);
        }
    }

    public static String appendQueryString(String url, String queryString) {
        if (url.endsWith("?") || url.endsWith("&")) {
            return url + queryString;
        }
        if (url.indexOf(63) != -1) {
            return url + "&" + queryString;
        }
        return url + "?" + queryString;
    }

    public static String stripQueryString(String url) {
        int index = url.indexOf(63);
        if (index == -1) {
            return url;
        }
        return url.substring(0, index);
    }

    public static String getQueryString(String url) {
        int index = url.indexOf(63);
        if (index == -1 || index == url.length() - 1) {
            return "";
        }
        return url.substring(index + 1);
    }

    public static String getParentUrl(String url) {
        int index;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if ((index = url.lastIndexOf(47)) == -1) {
            return url;
        }
        return url.substring(0, index);
    }

    public static String appendPath(String url, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return url.endsWith("/") ? url + path : url + "/" + path;
    }

    public static String stripRemainingPath(String path) {
        int index;
        int i = 0;
        if (path.startsWith("/")) {
            i = 1;
        }
        if ((index = path.indexOf(47, i)) > -1) {
            return path.substring(0, index);
        }
        return path;
    }

    public static String stripBeginningPath(String path) {
        int index;
        int i = 0;
        if (path.startsWith("/")) {
            i = 1;
        }
        if ((index = path.indexOf(47, i)) > -1) {
            return path.substring(index + 1);
        }
        return "";
    }

    public static String getLastPartOfPath(String path) {
        int j;
        int i = path.length();
        if (path.endsWith("/")) {
            --i;
        }
        if ((j = path.lastIndexOf("/")) == -1) {
            return path;
        }
        return path.substring(j + 1, i);
    }

    public static String getExtension(String uri) {
        int dot = uri.lastIndexOf(46);
        if (dot != -1) {
            return uri.substring(dot + 1);
        }
        return null;
    }

    public static String makePathAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }
}

