/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.media.jai.ImageFunction;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.RenderedSampleDimension;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridCoverageFactory
extends AbstractFactory {
    private final Hints userHints = null;

    public GridCoverageFactory() {
        this(null);
    }

    public GridCoverageFactory(Hints userHints) {
        CoordinateReferenceSystem defaultCRS = null;
        String tileEncoding = null;
        if (userHints != null) {
            defaultCRS = (CoordinateReferenceSystem)userHints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (Utilities.equals((Object)defaultCRS, (Object)DefaultGeographicCRS.WGS84) || Utilities.equals((Object)defaultCRS, (Object)DefaultGeographicCRS.WGS84_3D)) {
                defaultCRS = null;
            }
            if ((tileEncoding = (String)userHints.get((Object)Hints.TILE_ENCODING)) != null && (tileEncoding = tileEncoding.trim()).length() == 0) {
                tileEncoding = null;
            }
        }
        this.hints.put(Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, defaultCRS);
        this.hints.put(Hints.TILE_ENCODING, tileEncoding);
    }

    protected CoordinateReferenceSystem getDefaultCRS(int dimension) {
        CoordinateReferenceSystem candidate = (CoordinateReferenceSystem)this.hints.get(Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (candidate != null) {
            return candidate;
        }
        switch (dimension) {
            case 2: {
                return DefaultGeographicCRS.WGS84;
            }
            case 3: {
                return DefaultGeographicCRS.WGS84_3D;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)42, (Object)"dimension", (Object)dimension));
    }

    public GridCoverage2D create(CharSequence name, ImageFunction function, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Map properties) {
        MathTransform2D transform = gridGeometry.getGridToCRS2D();
        if (!(transform instanceof AffineTransform)) {
            throw new IllegalArgumentException(Errors.format((int)85));
        }
        AffineTransform at = (AffineTransform)transform;
        if (at.getShearX() != 0.0 || at.getShearY() != 0.0) {
            throw new IllegalArgumentException("Shear and rotation not supported");
        }
        double xScale = at.getScaleX();
        double yScale = at.getScaleY();
        double xTrans = -at.getTranslateX() / xScale;
        double yTrans = -at.getTranslateY() / yScale;
        GridRange range = gridGeometry.getGridRange();
        ParameterBlock param = new ParameterBlock().add(function).add(range.getLength(0)).add(range.getLength(1)).add((float)xScale).add((float)yScale).add((float)xTrans).add((float)yTrans);
        RenderedOp image = JAI.create((String)"ImageFunction", (ParameterBlock)param);
        return this.create(name, (RenderedImage)image, gridGeometry, bands, null, properties);
    }

    public GridCoverage2D create(CharSequence name, float[][] matrix, Envelope envelope) {
        int width = 0;
        int height = matrix.length;
        for (int j = 0; j < height; ++j) {
            float[] row = matrix[j];
            if (row == null || row.length <= width) continue;
            width = row.length;
        }
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
        for (int j = 0; j < height; ++j) {
            int i;
            float[] row = matrix[j];
            if (row != null) {
                for (i = 0; i < row.length; ++i) {
                    raster.setSample(i, j, 0, row[i]);
                }
            }
            while (i < width) {
                raster.setSample(i, j, 0, Float.NaN);
                ++i;
            }
        }
        return this.create(name, raster, envelope);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, Envelope envelope) {
        return this.create(name, raster, envelope, null, null, null, null, null);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, Envelope envelope, double[] minValues, double[] maxValues, Unit<?> units, Color[][] colors, RenderingHints hints) {
        GridSampleDimension[] bands = RenderedSampleDimension.create(name, raster, minValues, maxValues, units, colors, hints);
        ColorModel model = bands[0].getColorModel(0, bands.length);
        BufferedImage image = new BufferedImage(model, raster, false, null);
        return this.create(name, (RenderedImage)image, envelope, bands, null, null);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, MathTransform gridToCRS, double[] minValues, double[] maxValues, Unit<?> units, Color[][] colors, RenderingHints hints) {
        GridSampleDimension[] bands = RenderedSampleDimension.create(name, raster, minValues, maxValues, units, colors, hints);
        ColorModel model = bands[0].getColorModel(0, bands.length);
        BufferedImage image = new BufferedImage(model, raster, false, null);
        return this.create(name, image, crs, gridToCRS, bands, null, null);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, Envelope envelope, GridSampleDimension[] bands) {
        ColorModel model = bands[0].getColorModel(0, bands.length);
        BufferedImage image = new BufferedImage(model, raster, false, null);
        return this.create(name, (RenderedImage)image, envelope, bands, null, null);
    }

    public GridCoverage2D create(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, MathTransform gridToCRS, GridSampleDimension[] bands) {
        ColorModel model = bands[0].getColorModel(0, bands.length);
        BufferedImage image = new BufferedImage(model, raster, false, null);
        return this.create(name, image, crs, gridToCRS, bands, null, null);
    }

    public GridCoverage2D create(CharSequence name, RenderedImage image, Envelope envelope) {
        return this.create(name, image, envelope, null, null, null);
    }

    public GridCoverage2D create(CharSequence name, RenderedImage image, Envelope envelope, GridSampleDimension[] bands, GridCoverage[] sources, Map properties) {
        if (envelope.getCoordinateReferenceSystem() == null) {
            GeneralEnvelope e = new GeneralEnvelope(envelope);
            e.setCoordinateReferenceSystem(this.getDefaultCRS(e.getDimension()));
            envelope = e;
        }
        GridGeometry2D gm = new GridGeometry2D(new GeneralGridRange(image, envelope.getDimension()), envelope);
        return this.create(name, image, gm, bands, sources, properties);
    }

    public GridCoverage2D create(CharSequence name, RenderedImage image, CoordinateReferenceSystem crs, MathTransform gridToCRS, GridSampleDimension[] bands, GridCoverage[] sources, Map properties) {
        GridGeometry2D gm = new GridGeometry2D(new GeneralGridRange(image, crs.getCoordinateSystem().getDimension()), gridToCRS, crs);
        return this.create(name, image, gm, bands, sources, properties);
    }

    public GridCoverage2D create(CharSequence name, RenderedImage image, GridGeometry2D gridGeometry, GridSampleDimension[] bands, GridCoverage[] sources, Map<?, ?> properties) {
        if (!gridGeometry.isDefined(1)) {
            int dimension = gridGeometry.getDimension();
            gridGeometry = new GridGeometry2D(gridGeometry, this.getDefaultCRS(dimension));
        }
        GridCoverage2D coverage = new GridCoverage2D(name, PlanarImage.wrapRenderedImage((RenderedImage)image), gridGeometry, bands, sources, properties, this.userHints);
        coverage.tileEncoding = (String)this.hints.get(Hints.TILE_ENCODING);
        return coverage;
    }
}

