/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import net.opengis.wcs11.GetCoverageType;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.response.CoveragesTransformer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.WCS;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegateFactory;

public class WCSGetCoverageStoreResponse
extends Response {
    Data catalog;
    WCS wcs;

    public WCSGetCoverageStoreResponse(WCS wcs, Data catalog) {
        super(GridCoverage[].class);
        this.wcs = wcs;
        this.catalog = catalog;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/xml";
    }

    public boolean canHandle(Operation operation) {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        return getCoverage.getOutput().isStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        GridCoverage[] coverages = (GridCoverage[])value;
        GetCoverageType request = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = request.getOutput().getFormat();
        CoverageResponseDelegate delegate = CoverageResponseDelegateFactory.encoderFor((String)outputFormat);
        if (delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoverageInfo coverageInfo = this.catalog.getCoverageInfo(request.getIdentifier().getValue());
        File wcsStore = null;
        try {
            File temp = GeoserverDataDirectory.findCreateConfigDir((String)"temp");
            wcsStore = new File(temp, "wcs");
            if (!wcsStore.exists()) {
                wcsStore.mkdir();
            }
        }
        catch (Exception e) {
            throw new WcsException("Could not create the temporary storage directory for WCS");
        }
        File coverageFile = null;
        while ((coverageFile = new File(wcsStore, coverageInfo.getName().replace(':', '_') + "_" + System.nanoTime() + "." + delegate.getFileExtension())).exists()) {
        }
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(coverageFile));
            delegate.prepare(outputFormat, coverage);
            delegate.encode(os);
            os.flush();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        System.out.println(coverageFile);
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)request.getBaseUrl(), (String)this.wcs.getGeoServer().getProxyBaseUrl());
        String coverageLocation = proxifiedBaseUrl + "temp/wcs/" + coverageFile.getName();
        CoveragesTransformer tx = new CoveragesTransformer(this.wcs, request, coverageLocation);
        try {
            tx.transform(coverageInfo, output);
        }
        catch (TransformerException e) {
            throw new WcsException("Failure trying to encode Coverages response", (Throwable)e);
        }
    }
}

