/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.memory.UserAttribute;
import org.acegisecurity.userdetails.memory.UserAttributeEditor;
import org.geoserver.security.PropertyFileWatcher;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class EditableUserDAO
implements UserDetailsService {
    private Map myDetailStorage = new HashMap();
    private PropertyFileWatcher myWatcher;
    private GeoServer geoServer;

    private File getUserFile() throws ConfigurationException, IOException {
        File securityDir = GeoserverDataDirectory.findCreateConfigDir("security");
        File userFile = new File(securityDir, "users.properties");
        if (!userFile.exists() && !userFile.createNewFile()) {
            throw new ConfigurationException("Couldn't create users.properties");
        }
        return userFile;
    }

    public EditableUserDAO() {
        try {
            this.myWatcher = new PropertyFileWatcher(this.getUserFile());
        }
        catch (Exception e) {
            this.createDefaultUser();
        }
        this.update();
        if (this.myDetailStorage.isEmpty()) {
            this.createDefaultUser();
        }
    }

    private void createDefaultUser() {
        String name = this.geoServer == null ? "admin" : this.geoServer.getAdminUserName();
        String passwd = this.geoServer == null ? "geoserver" : this.geoServer.getAdminPassword();
        this.myDetailStorage.put(name, new User(name, passwd, true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ADMINISTRATOR")}));
    }

    public UserDetails loadUserByUsername(String username) {
        this.update();
        return (UserDetails)this.myDetailStorage.get(username);
    }

    public void setUserDetails(String username, UserAttribute details) throws IOException, ConfigurationException {
        this.update();
        this.myDetailStorage.put(username, this.makeUser(username, details));
        this.syncChanges();
    }

    public void deleteUser(String username) throws IOException, ConfigurationException {
        this.update();
        this.myDetailStorage.remove(username);
        this.syncChanges();
    }

    private void update() {
        try {
            if (this.myWatcher != null && this.myWatcher.isStale()) {
                Properties prop = this.myWatcher.getProperties();
                UserAttributeEditor uae = new UserAttributeEditor();
                this.myDetailStorage.clear();
                for (String string : prop.keySet()) {
                    uae.setAsText(prop.getProperty(string));
                    UserAttribute attrs = (UserAttribute)uae.getValue();
                    if (attrs == null) continue;
                    this.myDetailStorage.put(string, this.makeUser(string, attrs));
                }
            }
        }
        catch (IOException ioe) {
            this.myDetailStorage.clear();
            this.createDefaultUser();
        }
    }

    private UserDetails makeUser(String username, UserAttribute attrs) {
        return new User(username, attrs.getPassword(), attrs.isEnabled(), true, true, true, attrs.getAuthorities());
    }

    private void syncChanges() throws IOException, ConfigurationException {
        Properties prop = new Properties();
        for (UserDetails details : this.myDetailStorage.values()) {
            String key = details.getUsername();
            String value = details.getPassword();
            for (int i = 0; i < details.getAuthorities().length; ++i) {
                value = value + "," + details.getAuthorities()[i].getAuthority();
            }
            if (!details.isEnabled()) {
                value = value + ",disabled";
            }
            prop.setProperty(key, value);
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.getUserFile()));
        prop.store(os, "Geoserver user data. Format is username=password,role1,role2,...[enabled|disabled]");
    }

    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public Set getNameSet() {
        return this.myDetailStorage.keySet();
    }
}

