/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class LoggingInitializer {
    public static final String RELINQUISH_LOG4J_CONTROL = "RELINQUISH_LOG4J_CONTROL";
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.logging");
    GeoServerResourceLoader resourceLoader;

    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public int getPriority() {
        return -10;
    }

    public void initialize(GeoServer geoServer, ApplicationContext context) throws Exception {
        String strValue = GeoServerExtensions.getProperty((String)RELINQUISH_LOG4J_CONTROL, (ApplicationContext)context);
        boolean relinquishLoggingControl = Boolean.valueOf(strValue);
        if (relinquishLoggingControl) {
            return;
        }
        this.initLogging(geoServer.getGlobal());
        geoServer.addListener(new ConfigurationListener(){

            @Override
            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                boolean reload = false;
                if (propertyNames.contains("loggingLevel")) {
                    reload = true;
                }
                if (propertyNames.contains("loggingLocation")) {
                    reload = true;
                }
                if (propertyNames.contains("stdOutLogging")) {
                    reload = true;
                }
                if (reload) {
                    try {
                        LoggingInitializer.this.initLogging(global);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            }

            @Override
            public void reloaded() {
            }
        });
    }

    void initLogging(GeoServerInfo info) throws Exception {
        File log4jConfigFile;
        String log4jConfigFileStr = info.getLoggingLevel();
        boolean suppressStdOutLogging = !info.isStdOutLogging();
        String logFileName = info.getLoggingLocation();
        LOGGER.fine("CONFIGURING GEOSERVER LOGGING -------------------------");
        if (log4jConfigFileStr == null) {
            log4jConfigFileStr = "DEFAULT_LOGGING.properties";
            LOGGER.warning("No log4jConfigFile defined in services.xml:  using 'DEFAULT_LOGGING.properties'");
        }
        if ((log4jConfigFile = this.resourceLoader.find(new String[]{"logs", log4jConfigFileStr})) == null) {
            LOGGER.warning("log4jConfigFile '" + log4jConfigFileStr + "' couldn't be found in the data dir, so GeoServer will " + "install the various logging config file into the data dir, and then try to find it again.");
            File lcdir = this.resourceLoader.find("logs");
            if (lcdir == null) {
                lcdir = this.resourceLoader.createDirectory("logs");
            }
            String[] lcfiles = new String[]{"DEFAULT_LOGGING.properties", "VERBOSE_LOGGING.properties", "PRODUCTION_LOGGING.properties", "GEOTOOLS_DEVELOPER_LOGGING.properties", "GEOSERVER_DEVELOPER_LOGGING.properties"};
            for (int i = 0; i < lcfiles.length; ++i) {
                File target = new File(lcdir.getAbsolutePath(), lcfiles[i]);
                if (target.exists()) continue;
                this.resourceLoader.copyFromClassPath(lcfiles[i], target);
            }
            log4jConfigFile = this.resourceLoader.find(new String[]{"logs", log4jConfigFileStr});
            if (log4jConfigFile == null) {
                LOGGER.warning("Still couldn't find log4jConfigFile '" + log4jConfigFileStr + "'.  Using DEFAULT_LOGGING.properties instead.");
            }
            log4jConfigFile = this.resourceLoader.find(new String[]{"logs", "DEFAULT_LOGGING.properties"});
        }
        if (log4jConfigFile == null || !log4jConfigFile.exists()) {
            throw new ConfigurationException("Unable to load logging configuration '" + log4jConfigFileStr + "'.  In addition, an attempt " + "was made to create the 'logs' directory in your data dir, and to use the DEFAULT_LOGGING configuration, but" + "this failed as well.  Is your data dir writeable?");
        }
        FileInputStream loggingConfigStream = new FileInputStream(log4jConfigFile);
        if (loggingConfigStream == null) {
            LOGGER.warning("Couldn't open Log4J configuration file '" + log4jConfigFile.getAbsolutePath());
            return;
        }
        LOGGER.fine("GeoServer logging profile '" + log4jConfigFile.getName() + "' enabled.");
        LoggingInitializer.configureGeoServerLogging(loggingConfigStream, suppressStdOutLogging, false, logFileName);
    }

    public static void configureGeoServerLogging(InputStream loggingConfigStream, boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) throws FileNotFoundException, IOException, ConfigurationException {
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        Enumeration a = LogManager.getRootLogger().getAllAppenders();
        while (a.hasMoreElements()) {
            Appender appender = (Appender)a.nextElement();
            if (appender instanceof ConsoleAppender || appender instanceof FileAppender) continue;
            appenders.add(appender);
        }
        Properties lprops = new Properties();
        lprops.load(loggingConfigStream);
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)lprops);
        if (!suppressFileLogging) {
            Appender gslf = org.apache.log4j.Logger.getRootLogger().getAppender("geoserverlogfile");
            if (gslf instanceof RollingFileAppender) {
                if (logFileName == null) {
                    logFileName = new File(GeoserverDataDirectory.findCreateConfigDir("logs"), "geoserver.log").getAbsolutePath();
                } else if (!new File(logFileName).isAbsolute()) {
                    logFileName = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), logFileName).getAbsolutePath();
                    LOGGER.fine("Non-absolute pathname detected for logfile.  Setting logfile relative to data dir.");
                }
                lprops.setProperty("log4j.appender.geoserverlogfile.File", logFileName);
                PropertyConfigurator.configure((Properties)lprops);
                LOGGER.fine("Logging output to file '" + logFileName + "'");
            } else if (gslf != null) {
                LOGGER.warning("'log4j.appender.geoserverlogfile' appender is defined, but isn't a RollingFileAppender.  GeoServer won't control the file-based logging.");
            } else {
                LOGGER.warning("'log4j.appender.geoserverlogfile' appender isn't defined.  GeoServer won't control the file-based logging.");
            }
        }
        if (suppressStdOutLogging) {
            LOGGER.warning("Suppressing StdOut logging.  If you want to see GeoServer logs, be sure to look in '" + logFileName + "'");
            Enumeration allAppenders = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender curApp = (Appender)allAppenders.nextElement();
                if (!(curApp instanceof ConsoleAppender)) continue;
                org.apache.log4j.Logger.getRootLogger().removeAppender(curApp);
            }
        }
        for (Appender appender : appenders) {
            LogManager.getRootLogger().addAppender(appender);
        }
        LOGGER.fine("FINISHED CONFIGURING GEOSERVER LOGGING -------------------------");
    }
}

