/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.impl.ProxyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationProxy
implements InvocationHandler {
    Object proxyObject;
    HashMap<String, Object> properties;

    public ModificationProxy(Object proxyObject) {
        this.proxyObject = proxyObject;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String property;
        if ((method.getName().startsWith("get") || method.getName().startsWith("is")) && method.getParameterTypes().length == 0) {
            property = method.getName().substring(method.getName().startsWith("get") ? 3 : 2);
            if (this.properties != null && this.properties().containsKey(property)) {
                return this.properties().get(property);
            }
            if (Collection.class.isAssignableFrom(method.getReturnType())) {
                Collection real = (Collection)method.invoke(this.proxyObject, null);
                Collection wrap = (Collection)real.getClass().newInstance();
                wrap.addAll(real);
                this.properties().put(property, wrap);
                return wrap;
            }
        }
        if (method.getName().startsWith("set") && args.length == 1) {
            property = method.getName().substring(3);
            this.properties().put(property, args[0]);
            return null;
        }
        return method.invoke(this.proxyObject, args);
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public HashMap<String, Object> getProperties() {
        return this.properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.proxyObject;
        synchronized (object) {
            for (Map.Entry<String, Object> e : this.properties().entrySet()) {
                String p = e.getKey();
                Object v = e.getValue();
                try {
                    Method g = this.getter(p);
                    if (Collection.class.isAssignableFrom(g.getReturnType())) {
                        Collection c = (Collection)g.invoke(this.proxyObject, null);
                        c.clear();
                        c.addAll((Collection)v);
                        continue;
                    }
                    Method s = this.proxyObject.getClass().getMethod("set" + p, g.getReturnType());
                    s.invoke(this.proxyObject, v);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.properties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, Object> properties() {
        if (this.properties != null) {
            return this.properties;
        }
        ModificationProxy modificationProxy = this;
        synchronized (modificationProxy) {
            if (this.properties != null) {
                return this.properties;
            }
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public List<String> getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (String propertyName : this.properties().keySet()) {
            propertyNames.add(Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1));
        }
        return propertyNames;
    }

    public List<Object> getOldValues() {
        ArrayList<Object> oldValues = new ArrayList<Object>();
        for (String propertyName : this.properties().keySet()) {
            try {
                Method g = this.getter(propertyName);
                if (g == null) {
                    throw new IllegalArgumentException("No such property: " + propertyName);
                }
                oldValues.add(g.invoke(this.proxyObject, null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return oldValues;
    }

    public List<Object> getNewValues() {
        return new ArrayList<Object>(this.properties().values());
    }

    Method getter(String propertyName) {
        Method g = null;
        try {
            g = this.proxyObject.getClass().getMethod("get" + propertyName, null);
        }
        catch (NoSuchMethodException e1) {
            try {
                g = this.proxyObject.getClass().getMethod("is" + propertyName, null);
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        return g;
    }

    public static <T> T create(T proxyObject, Class<T> clazz) {
        Object proxy;
        ModificationProxy h = new ModificationProxy(proxyObject);
        List<Class<?>> proxyInterfaces = Arrays.asList(proxyObject.getClass().getInterfaces());
        boolean add = true;
        for (Class<?> interfce : proxyObject.getClass().getInterfaces()) {
            if (!clazz.isAssignableFrom(interfce)) continue;
            add = false;
            break;
        }
        if (add) {
            proxyInterfaces.add(clazz);
        }
        Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), proxyInterfaces.toArray(new Class[proxyInterfaces.size()]));
        try {
            proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(h);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)proxy;
    }

    public static <T> List<T> createList(List<T> proxyList, Class<T> clazz) {
        return new ProxyList(proxyList, clazz){

            @Override
            protected <T> T createProxy(T proxyObject, Class<T> proxyInterface) {
                return ModificationProxy.create(proxyObject, proxyInterface);
            }
        };
    }

    public static <T> T unwrap(T object) {
        InvocationHandler h;
        if (object instanceof Proxy && (h = Proxy.getInvocationHandler(object)) instanceof ModificationProxy) {
            return (T)((ModificationProxy)h).getProxyObject();
        }
        if (object instanceof ProxyList) {
            return (T)((ProxyList)object).proxyList;
        }
        return object;
    }
}

