/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.sql.Connection;
import java.util.Map;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.kml.CachedHierarchyRegionatingStrategy;

public class NativeSortRegionatingStrategy
extends CachedHierarchyRegionatingStrategy {
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    String attribute;
    FeatureSource fs;

    protected String getDatabaseName(WMSMapContext con, MapLayer layer) throws Exception {
        this.fs = layer.getFeatureSource();
        SimpleFeatureType type = (SimpleFeatureType)this.fs.getSchema();
        Map options = con.getRequest().getFormatOptions();
        this.attribute = (String)options.get("regionateAttr");
        if (this.attribute == null) {
            this.attribute = this.typeInfo.getRegionateAttribute();
        }
        if (this.attribute == null) {
            throw new WmsException("Regionating attribute has not been specified");
        }
        AttributeType attributeType = type.getType(this.attribute);
        if (attributeType == null) {
            throw new WmsException("Could not find regionating attribute " + this.attribute + " in layer " + this.typeInfo.getName());
        }
        if (!this.fs.getQueryCapabilities().supportsSorting(new SortBy[]{ff.sort(this.attribute, SortOrder.DESCENDING)})) {
            throw new WmsException("Native sorting on the " + this.attribute + " is not possible for layer " + this.typeInfo.getName());
        }
        return super.getDatabaseName(con, layer) + "_" + this.attribute;
    }

    protected String getDatabaseName(FeatureTypeInfo cfg) throws Exception {
        return super.getDatabaseName(cfg) + "_" + cfg.getRegionateAttribute();
    }

    public FeatureIterator getSortedFeatures(GeometryDescriptor geom, ReferencedEnvelope latLongEnv, ReferencedEnvelope nativeEnv, Connection cacheConn) throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX filter = ff.bbox(geom.getLocalName(), nativeEnv.getMinX(), nativeEnv.getMinY(), nativeEnv.getMaxX(), nativeEnv.getMaxY(), null);
        DefaultQuery q = new DefaultQuery();
        q.setFilter((Filter)filter);
        q.setPropertyNames(new String[]{geom.getLocalName(), this.attribute});
        q.setSortBy(new SortBy[]{ff.sort(this.attribute, SortOrder.DESCENDING)});
        return this.fs.getFeatures((Query)q).features();
    }
}

