/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.LegacyServiceExceptionHandler;
import org.geoserver.ows.OWS;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.vfny.geoserver.global.GeoServer;

public class WmsExceptionHandler
extends LegacyServiceExceptionHandler {
    static final Set<String> FORMATS = new HashSet<String>(Arrays.asList("image/png", "image/png8", "image/gif", "image/jpeg"));
    static final Map<String, String> IMAGEIO_FORMATS = new HashMap<String, String>(){
        {
            this.put("image/png", "png");
            this.put("image/png8", "png");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpeg");
        }
    };

    public WmsExceptionHandler(Service service, OWS ows, GeoServer geoServer) {
        super(service, ows, geoServer);
    }

    public void handleServiceException(ServiceException exception, Request request) {
        String format;
        int height;
        int width;
        String exceptions;
        try {
            exceptions = (String)request.getKvp().get("EXCEPTIONS");
            width = (Integer)request.getKvp().get("WIDTH");
            height = (Integer)request.getKvp().get("HEIGHT");
            format = (String)request.getKvp().get("FORMAT");
        }
        catch (Exception e) {
            super.handleServiceException(exception, request);
            return;
        }
        if (exceptions == null || !"application/vnd.ogc.se_inimage".equals(exceptions) || width <= 0 || height <= 0 || !FORMATS.contains(format)) {
            super.handleServiceException(exception, request);
            return;
        }
        BufferedImage img = new BufferedImage(width, height, 6);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.setColor(Color.BLACK);
        this.paintLines(g, this.buildExceptionText(exception), width - 2, 35, 5);
        g.dispose();
        try {
            HttpServletResponse response = request.getHttpResponse();
            response.setContentType(format);
            ServletOutputStream os = response.getOutputStream();
            ImageIO.write((RenderedImage)img, IMAGEIO_FORMATS.get(format), (OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", e);
        }
    }

    String buildExceptionText(ServiceException exception) {
        StringBuffer sb = new StringBuffer();
        if (exception.getCode() != null && !exception.getCode().equals("")) {
            sb.append("code=\"" + exception.getCode() + "\"");
        }
        if (exception.getLocator() != null && !exception.getLocator().equals("")) {
            sb.append(" locator=\"" + exception.getLocator() + "\"");
        }
        if (exception.getMessage() != null) {
            this.dumpExceptionMessages(exception, sb, false);
            if (this.geoServer.isVerboseExceptions()) {
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(stackTrace));
                sb.append("\nDetails:\n");
                sb.append(new String(stackTrace.toByteArray()));
            }
        }
        return sb.toString();
    }

    void paintLines(Graphics2D g, String text, int lineWidth, int startX, int startY) {
        String[] lines = text.split("\\n");
        Point cursor = new Point(startX, startY);
        FontMetrics metrics = g.getFontMetrics();
        int lineHeight = metrics.getAscent() + metrics.getDescent() + metrics.getLeading();
        FontRenderContext frc = g.getFontRenderContext();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if ("".equals(line)) {
                cursor.y += lineHeight;
                continue;
            }
            AttributedString styledText = new AttributedString(line);
            LineBreakMeasurer measurer = new LineBreakMeasurer(styledText.getIterator(), frc);
            while (measurer.getPosition() < line.length()) {
                TextLayout layout = measurer.nextLayout(lineWidth);
                cursor.y = (int)((float)cursor.y + layout.getAscent());
                float dx = layout.isLeftToRight() ? 0.0f : (float)lineWidth - layout.getAdvance();
                layout.draw(g, (float)cursor.x + dx, cursor.y);
                cursor.y = (int)((float)cursor.y + (layout.getDescent() + layout.getLeading()));
            }
        }
    }
}

