/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public abstract class FeatureTypeSchema {
    protected FeatureTypeInfo featureType;
    protected FeatureTypeSchemaBuilder builder;
    protected Data catalog;
    protected WFS wfs;
    protected GeoServerResourceLoader loader;

    protected FeatureTypeSchema(FeatureTypeInfo featureType, WFS wfs, Data catalog, GeoServerResourceLoader loader) {
        this.featureType = featureType;
        this.catalog = catalog;
        this.wfs = wfs;
        this.loader = loader;
    }

    FeatureTypeInfo getFeatureType() {
        return this.featureType;
    }

    public XSDSchema schema(String baseUrl) throws IOException {
        return this.builder.build(new FeatureTypeInfo[]{this.featureType}, baseUrl);
    }

    public FeatureTypeSchema toGML2() {
        if (this instanceof GML2) {
            return this;
        }
        return new GML2(this.featureType, this.wfs, this.catalog, this.loader);
    }

    public FeatureTypeSchema toGML3() {
        if (this instanceof GML3) {
            return this;
        }
        return new GML3(this.featureType, this.wfs, this.catalog, this.loader);
    }

    public static final class GML3
    extends FeatureTypeSchema {
        protected GML3(FeatureTypeInfo featureType, WFS wfs, Data catalog, GeoServerResourceLoader loader) {
            super(featureType, wfs, catalog, loader);
            this.builder = new FeatureTypeSchemaBuilder.GML3(wfs, catalog, loader);
        }
    }

    public static final class GML2
    extends FeatureTypeSchema {
        public GML2(FeatureTypeInfo featureType, WFS wfs, Data catalog, GeoServerResourceLoader loader) {
            super(featureType, wfs, catalog, loader);
            this.builder = new FeatureTypeSchemaBuilder.GML2(wfs, catalog, loader);
        }
    }
}

